package {
	import br.com.stimuli.loading.BulkLoader;
	import br.com.stimuli.loading.BulkProgressEvent;

	import net.saqoosha.display.Stage;

	import ru.inspirit.net.MultipartURLLoader;

	import com.adobe.images.JPGEncoder;
	import com.adobe.serialization.json.JSON;
	import com.bit101.components.HBox;
	import com.bit101.components.PushButton;

	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.LoaderInfo;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.geom.Matrix;
	import flash.net.FileFilter;
	import flash.net.FileReference;
	import flash.net.URLLoaderDataFormat;
	import flash.utils.ByteArray;

	[SWF(backgroundColor='#ffffff', frameRate='30', width='1024', height='768')]
	
	/**
	 * @author hiko
	 */
	public class KumaBu extends Sprite {

		
		public static const API_KEY:String = 'Face.com でアカウント作って取得してくださいな。';
		public static const API_SECRET:String = 'ここです → http://developers.face.com/account/';
		
		public static const NUM_KUMA_IMAGES:int = 6;


		private var _kumaImages:Array;

		private var _buttons:HBox;
		private var _saveButton:PushButton;
		
		private var _file:FileReference;
		private var _filename:String;
		private var _target:BitmapData;
		private var _bitmap:Bitmap;

		
		public function KumaBu() {
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			Stage.init(stage);
			
			var loader:BulkLoader = new BulkLoader();
			loader.addEventListener(BulkProgressEvent.COMPLETE, _onKumaLoaded);
			for (var i:int = 1; i <= NUM_KUMA_IMAGES; ++i) {
				loader.add('kuma/kuma' + i + '.png', {id: 'k' + i});
			}
			loader.start();
		}

		
		private function _onKumaLoaded(event:BulkProgressEvent):void {
			var loader:BulkLoader = BulkLoader(event.target);
			_kumaImages = [];
			for (var i:int = 1; i <= NUM_KUMA_IMAGES; ++i) {
				_kumaImages.push(loader.getBitmapData('k' + i));
			}
			
			_buttons = new HBox(this, 10, 10);
			new PushButton(_buttons, 0, 0, 'LOAD PHOTO', _onClickLoad);
			_saveButton = new PushButton(_buttons, 0, 0, 'SAVE PHOTO', _onClickSave);
			_saveButton.visible = false;
		}

		
		private function _onClickLoad(event:Event):void {
			_buttons.visible = false;
			_file = new FileReference();
			_file.addEventListener(Event.SELECT, _onFileSelect);
			_file.addEventListener(Event.CANCEL, _onFileCancel);
			_file.browse([new FileFilter('Photo', '*.jpg')]);
		}

		
		private function _onFileCancel(event:Event):void {
			_buttons.visible = true;
		}

		
		private function _onFileSelect(event:Event):void {
			_filename = _file.name;
			_file.removeEventListener(Event.SELECT, _onFileSelect);
			_file.addEventListener(Event.COMPLETE, _onFileLoadComplete);
			_file.load();
		}

		
		private function _onFileLoadComplete(event:Event):void {
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, _onImageLoadComplete);
			loader.loadBytes(_file.data);
			
			_file.removeEventListener(Event.COMPLETE, _onFileLoadComplete);
			_file = null;
		}

		
		private function _onImageLoadComplete(event:Event):void {
			if (_bitmap) {
				removeChild(_bitmap);
				_bitmap = null;
				_target.dispose();
				_target = null;
			}
			
			var loader:Loader = LoaderInfo(event.target).loader;
			_target = Bitmap(loader.content).bitmapData;
			if (_target.width > 900 || _target.height > 900) {
				var s:Number = Math.min(900 / _target.width, 900 / _target.height);
				var resized:BitmapData = new BitmapData(_target.width * s, _target.height * s, false, 0x0);
				Stage.doInQuality(StageQuality.BEST, function ():void {
					resized.draw(_target, new Matrix(s, 0, 0, s, 0, 0), null, null, null, true);
				});
				_target.dispose();
				_target = resized;
			}
			_bitmap = addChildAt(new Bitmap(_target), 0) as Bitmap;
			
			var encoder:JPGEncoder = new JPGEncoder(80);
			var jpeg:ByteArray = encoder.encode(_target);

			var detector:MultipartURLLoader = new MultipartURLLoader();
			detector.dataFormat = URLLoaderDataFormat.TEXT;
			detector.addEventListener(Event.COMPLETE, _onDetected);
			detector.addVariable('api_key', API_KEY);
			detector.addVariable('api_secret', API_SECRET);
			detector.addFile(jpeg, 'image.jpg', 'imageFile', 'image/jpeg');
			detector.load('http://api.face.com/faces/detect.json');
		}

		
		private function _onDetected(event:Event):void {
			var result:Object = JSON.decode(event.target.loader.data);
			if (result.status == 'success') {
				var kuma:Array = [];
				for each (var tag:Object in result.photos[0].tags) {
					kuma.push({
						x: tag.center.x,
						y: tag.center.y,
						width: Number(tag.width),
						height: Number(tag.height),
						roll: Number(tag.roll)
					});
				}
				kuma = kuma.sortOn('y', Array.NUMERIC);
				Stage.doInQuality(StageQuality.BEST, function ():void {
					for each (var k:Object in kuma) {
						_drawKuma(k.x, k.y, k.width, k.height, k.roll);
					}
				});
				_saveButton.visible = true;
			}
			_buttons.visible = true;
		}

		
		private function _drawKuma(x:Number, y:Number, width:Number, height:Number, roll:Number):void {
			var kuma:BitmapData = _kumaImages[int(Math.random() * _kumaImages.length)];
			var mtx:Matrix = new Matrix();
			var w:Number = _target.width * width / 100 * 2.4;
			var h:Number = _target.height * height / 100 * 2.4;
			mtx.scale(w / kuma.width, h / kuma.height);
			mtx.translate(-w * 0.5, -h * 0.7);
			mtx.rotate(roll * Math.PI / 180);
			mtx.translate(_target.width * x / 100, _target.height * y / 100);
			_target.draw(kuma, mtx, null, null, null, true);
		}

		
		private function _onClickSave(event:Event):void {
			var encoder:JPGEncoder = new JPGEncoder(95);
			_file = new FileReference();
			_file.save(encoder.encode(_target), _filename.replace(/¥.jpg$/, '_KumaBu.jpg'));
		}
	}
}
