package {
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Matrix;
	import flash.geom.Rectangle;
	import flash.utils.ByteArray;
	
	import net.saqoosha.colorlog.ColorLog;
	import net.saqoosha.colorlog.SGR;
	
	[SWF(width=500, height=500, backgroundColor=0x0, frameRate=15)]

	public class TestColorLog4 extends Sprite {
		
		[Embed(source='saqoosha.jpg')]
		private static const imageClass:Class;
		
		private static const COLORS:Array = [
			SGR.BG_NORMAL_BLACK,
			SGR.BG_BRIGHT_BLUE,
			SGR.BG_BRIGHT_GREEN,
			SGR.BG_BRIGHT_CYAN,
			SGR.BG_BRIGHT_RED,
			SGR.BG_BRIGHT_MAGENTA,
			SGR.BG_BRIGHT_YELLOW,
			SGR.BG_BRIGHT_WHITE
		];
		
		private var _canvas:BitmapData;
		private var _y:int;
		
		public function TestColorLog4() {
			this._canvas = new BitmapData(100, 50, false, 0);
			var b:Bitmap = new Bitmap(this._canvas);
			b.scaleX = 5;
			b.scaleY = 10;
			this.addChild(b);

			var img:BitmapData = Bitmap(new imageClass()).bitmapData;
			var mtx:Matrix = new Matrix(100 / img.width, 0, 0, 50 / img.height, 0, 0);
			this._canvas.draw(img, mtx);
			
			this._y = 0;
			this.addEventListener(Event.ENTER_FRAME, this._update);
		}
		
		private function _update(e:Event):void {
			var n:int = this._canvas.width;
			var b:ByteArray = this._canvas.getPixels(new Rectangle(0, this._y, n, 1));
//			ColorLog.moveTo(this._y + 1, 1);
			for (var i:int = 0; i < n; i++) {
				var p:int = i * 4;
				var c:int = (b[p + 1] & 0x80) ? 0x4 : 0;
				c |= (b[p + 2] & 0x80) ? 0x2 : 0;
				c |= (b[p + 3] & 0x80) ? 0x1 : 0;
				ColorLog.setColor(COLORS[c]);
				ColorLog.out(' ');
			}
			ColorLog.flush();
			if (++this._y == this._canvas.height) {
				this.removeEventListener(Event.ENTER_FRAME, this._update);
			}
		}
	}
}