package {

	import br.com.stimuli.loading.BulkLoader;
	import br.com.stimuli.loading.BulkProgressEvent;

	import cmodule.OpenJTalk.CLibInit;

	import com.bit101.components.HUISlider;
	import com.bit101.components.ProgressBar;
	import com.bit101.components.PushButton;
	import com.bit101.components.VBox;

	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.text.TextField;
	import flash.text.TextFieldType;
	import flash.text.TextFormat;
	import flash.utils.ByteArray;
	import flash.utils.Endian;
	import flash.utils.getTimer;


	/**
	 * @author Saqoosha
	 */
	[SWF(backgroundColor="#FFFFFF", frameRate="30", width="1024", height="768")]
	public class exp01 extends Sprite {


		//  options:                                                                   [  def][ min--max]
		//    -x dir         : dictionary directory                                    [  N/A]
		//    -td tree       : decision trees file for state duration                  [  N/A]
		//    -tm tree       : decision trees file for spectrum                        [  N/A]
		//    -tf tree       : decision trees file for Log F0                          [  N/A]
		//    -tl tree       : decision trees file for low-pass filter                 [  N/A]
		//    -md pdf        : model file for state duration                           [  N/A]
		//    -mm pdf        : model file for spectrum                                 [  N/A]
		//    -mf pdf        : model file for Log F0                                   [  N/A]
		//    -ml pdf        : model file for low-pass filter                          [  N/A]
		//    -dm win        : window files for calculation delta of spectrum          [  N/A]
		//    -df win        : window files for calculation delta of Log F0            [  N/A]
		//    -dl win        : window files for calculation delta of low-pass filter   [  N/A]
		//    -ow s          : filename of output wav audio (generated speech)         [  N/A]
		//    -ot s          : filename of output trace information                    [  N/A]
		//    -s  i          : sampling frequency                                      [16000][   1--48000]
		//    -p  i          : frame period (point)                                    [   80][   1--]
		//    -a  f          : all-pass constant                                       [ 0.42][ 0.0--1.0]
		//    -g  i          : gamma = -1 / i (if i=0 then gamma=0)                    [    0][   0-- ]
		//    -b  f          : postfiltering coefficient                               [  0.0][-0.8--0.8]
		//    -l             : regard input as log gain and output linear one (LSP)    [  N/A]
		//    -u  f          : voiced/unvoiced threshold                               [  0.5][ 0.0--1.0]
		//    -em tree       : decision tree file for GV of spectrum                   [  N/A]
		//    -ef tree       : decision tree file for GV of Log F0                     [  N/A]
		//    -el tree       : decision tree file for GV of low-pass filter            [  N/A]
		//    -cm pdf        : filename of GV for spectrum                             [  N/A]
		//    -cf pdf        : filename of GV for Log F0                               [  N/A]
		//    -cl pdf        : filename of GV for low-pass filter                      [  N/A]
		//    -jm f          : weight of GV for spectrum                               [  1.0][ 0.0--2.0]
		//    -jf f          : weight of GV for Log F0                                 [  1.0][ 0.0--2.0]
		//    -jl f          : weight of GV for low-pass filter                        [  1.0][ 0.0--2.0]
		//    -k  tree       : use GV switch                                           [  N/A]
		//    -z  i          : audio buffer size                                       [ 1600][   0--48000]
		private static const ARGV:Array = [
			'-td', 'tree-dur.inf',
			'-tf', 'tree-lf0.inf',
			'-tm', 'tree-mgc.inf',
			'-md', 'dur.pdf',
			'-mf', 'lf0.pdf',
			'-mm', 'mgc.pdf',
			'-df', 'lf0.win1',
			'-df', 'lf0.win2',
			'-df', 'lf0.win3',
			'-dm', 'mgc.win1',
			'-dm', 'mgc.win2',
			'-dm', 'mgc.win3',
			'-cf', 'gv-lf0.pdf',
			'-cm', 'gv-mgc.pdf',
			'-ef', 'tree-gv-lf0.inf',
			'-em', 'tree-gv-mgc.inf',
			'-k',  'gv-switch.inf',
			'-x',  'open_jtalk_dic_utf_8-1.04',
			'-s',  '44100',
			'-z',  '6000',
//			'-p',  '220',
//			'-a',  '0.58',
//			'-jm', '0.7',
//			'-jf', '0.5',
			'-l'
		];

		private static const DIC_PATH_PREFIX:String = 'open_jtalk_dic_utf_8-1.04/';
		private static const DIC_FILE_LIST:Array = [
			'sys.dic', 628,
			'unk.dic', 1,
			'matrix.bin', 38,
			'char.bin', 3,
			'rewrite.def', 1,
			'left-id.def', 1,
			'right-id.def', 1,
			'pos-id.def', 1
		];
		
		private static const VOICE_PATH_PREFIX:String = 'mei_normal/';
		private static const VOICE_FILE_LIST:Array = [
			'tree-dur.inf', 1,
			'tree-lf0.inf', 2,
			'tree-mgc.inf', 1,
			'dur.pdf', 1,
			'lf0.pdf', 1,
			'mgc.pdf', 6,
			'lf0.win1', 1,
			'lf0.win2', 1,
			'lf0.win3', 1,
			'mgc.win1', 1,
			'mgc.win2', 1,
			'mgc.win3', 1,
			'gv-lf0.pdf', 1,
			'gv-mgc.pdf', 1,
			'tree-gv-lf0.inf', 1,
			'tree-gv-mgc.inf', 1,
			'gv-switch.inf', 1
		];
		

		private var _progress:ProgressBar;
		private var _loader:BulkLoader;
		private var _jtalk:Object;
		private var _log:TextField;
		private var _text:TextField;
		private var _framePeriod:HUISlider;
		private var _allPassConst:HUISlider;
		private var _postFilter:HUISlider;
		private var _jm:HUISlider;
		private var _jf:HUISlider;
		private var _jl:HUISlider;


		public function exp01() {
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			_progress = new ProgressBar(this, 10, 10);

			_loader = new BulkLoader();
			var i:int, n:int, file:String;
			for (i = 0, n = DIC_FILE_LIST.length; i < n; i += 2) {
				file = DIC_FILE_LIST[i];
				_loader.add(DIC_PATH_PREFIX + file, {id: file, type:BulkLoader.TYPE_BINARY, weight: DIC_FILE_LIST[i + 1]});
			}
			for (i = 0, n = VOICE_FILE_LIST.length; i < n; i += 2) {
				file = VOICE_FILE_LIST[i];
				_loader.add(VOICE_PATH_PREFIX + file, {id: file, type:BulkLoader.TYPE_BINARY, weight: VOICE_FILE_LIST[i + 1]});
			}
			_loader.addEventListener(BulkProgressEvent.PROGRESS, _onLoadProgress);
			_loader.addEventListener(BulkProgressEvent.COMPLETE, _onLoadedComplete);
			_loader.start();
		}


		private function _onLoadProgress(e:BulkProgressEvent):void {
			_progress.value = e.weightPercent;
		}


		private function _onLoadedComplete(e:BulkProgressEvent):void {
			removeChild(_progress);
			_progress = null;
			
			var clib:CLibInit = new CLibInit(), file:String;
			for each (file in DIC_FILE_LIST) clib.supplyFile(DIC_PATH_PREFIX + file, _loader.getBinary(file));
			for each (file in VOICE_FILE_LIST) clib.supplyFile(file, _loader.getBinary(file));
			clib.setSprite(this);
			_jtalk = clib.init();
			
			_log = TextField(getChildAt(0));
			var fmt:TextFormat = new TextFormat('_typewriter', 12);
			_log.defaultTextFormat = fmt;
			_log.setTextFormat(fmt);
			_log.wordWrap = true;
			_log.background = true;
			_log.backgroundColor = 0xf4f4f4;
			
			_text = new TextField();
			_text.type = TextFieldType.INPUT;
			_text.defaultTextFormat = new TextFormat('_sans', 12, 0x0);
			_text.multiline = false;
			_text.wordWrap = true;
			_text.maxChars = 1000;
			_text.border = true;
			_text.borderColor = 0x888888;
			_text.x = 10;
			_text.y = 10;
			_text.width = 300;
			_text.height = 100;
			_text.text = 'さくさくさくうしゃ';
			addChild(_text);
			
			var vbox:VBox = new VBox(this, 10, 115);
			_framePeriod = new HUISlider(vbox, 0, 0, 'FRAME PERIOD');
			_framePeriod.minimum = 1;
			_framePeriod.maximum = 500;
			_framePeriod.value = 220;
			_framePeriod.tick = 1;
			_framePeriod.labelPrecision = 0;
			_framePeriod.width = 300;
			_allPassConst = new HUISlider(vbox, 0, 0, 'ALL-PASS CONST');
			_allPassConst.minimum = 0.0;
			_allPassConst.maximum = 1.0;
			_allPassConst.value = 0.54;
			_allPassConst.tick = 0.01;
			_allPassConst.labelPrecision = 2;
			_allPassConst.width = 300;
//			_postFilter = new HUISlider(vbox, 0, 0, 'POST FILTER');
//			_postFilter.minimum = -0.8;
//			_postFilter.maximum = 0.8;
//			_postFilter.value = 0;
//			_postFilter.tick = 0.01;
//			_postFilter.labelPrecision = 2;
//			_postFilter.width = 300;
			_jm = new HUISlider(vbox, 0, 0, 'SPECTRUM WEIGHT');
			_jm.minimum = 0.0;
			_jm.maximum = 2.0;
			_jm.value = 0.7;
			_jm.tick = 0.01;
			_jm.labelPrecision = 2;
			_jm.width = 300;
			_jf = new HUISlider(vbox, 0, 0, 'LOG F0 WEIGHT');
			_jf.minimum = 0.0;
			_jf.maximum = 2.0;
			_jf.value = 0.5;
			_jf.tick = 0.01;
			_jf.labelPrecision = 2;
			_jf.width = 300;
			_jl = new HUISlider(vbox, 0, 0, 'LOW-PASS FILT WEIGHT');
			_jl.minimum = 0.0;
			_jl.maximum = 2.0;
			_jl.value = 1.0;
			_jl.tick = 0.01;
			_jl.labelPrecision = 2;
			_jl.width = 300;
			new PushButton(vbox, 0, 0, 'SYNTHESIS', _onClickSynth);
			
			stage.addEventListener(Event.RESIZE, _onResize);
			_onResize(null);
		}
		
		
		private function _onClickSynth(e:Event):void {
			if (_text.length == 0) return;
		
			_log.text = '';
			var opt:Array = [];
			opt.push('-p', _framePeriod.value.toString());
			opt.push('-a', _allPassConst.value.toFixed(2));
//			opt.push('-b', _postFilter.value.toFixed(2));
			opt.push('-jm', _jm.value.toFixed(2));
			opt.push('-jf', _jf.value.toFixed(2));
			opt.push('-jl', _jl.value.toFixed(2));
			var start:int = getTimer();
			var handle:int = _jtalk.init(ARGV.concat(opt).join('|'));
			_trace('init', getTimer() - start, 'ms');
			start = getTimer();
			var data:ByteArray = new ByteArray();
			data.endian = Endian.LITTLE_ENDIAN;
			var log:ByteArray = new ByteArray();
			_jtalk.synthesis(handle, _text.text, data, log);
			_trace('synthesis', getTimer() - start, 'ms');
			_trace(log.readUTFBytes(log.bytesAvailable));
			new SoundDataPlayer(data).play();
			_jtalk.destroy(handle);
		}


		private function _onResize(e:Event):void {
			_log.x = 320;
			_log.y = 10;
			_log.width = stage.stageWidth - 330;
			_log.height = stage.stageHeight - 20;
		}
		
		
		private function _trace(...args):void {
			_log.appendText(args.join(' ') + '\n');
		}
	}
}


import flash.events.SampleDataEvent;
import flash.media.Sound;
import flash.utils.ByteArray;


class SoundDataPlayer extends Sound {


	private var _data:ByteArray;


	public function SoundDataPlayer(data:ByteArray) {
		_data = data;
		addEventListener(SampleDataEvent.SAMPLE_DATA, _onSampleData);
	}


	private function _onSampleData(event:SampleDataEvent):void {
		var i:int,
			val:Number;
		for (i = 0; i < 2048 && _data.bytesAvailable; i++) {
			val = _data.readShort() / 0x8000;
			event.data.writeFloat(val);
			event.data.writeFloat(val);
		}
	}
}
