/*
 * bytearrayfile.c
 *
 *  Created on: Oct 10, 2011
 *      Author: Saqoosha
 */

#include <stdlib.h>
#include <stdio.h>

#include "AS3.h"

/* Does a FILE * read against a ByteArray */
static int readByteArray(void *cookie, char *dst, int size) {
	return AS3_ByteArray_readBytes(dst, (AS3_Val) cookie, size);
}

/* Does a FILE * write against a ByteArray */
static int writeByteArray(void *cookie, const char *src, int size) {
	return AS3_ByteArray_writeBytes((AS3_Val) cookie, (char *) src, size);
}

/* Does a FILE * lseek against a ByteArray */
static fpos_t seekByteArray(void *cookie, fpos_t offs, int whence) {
	return AS3_ByteArray_seek((AS3_Val) cookie, offs, whence);
}

/* Does a FILE * close against a ByteArray */
static int closeByteArray(void * cookie) {
	AS3_Val zero = AS3_Int(0);

	/* just reset the position */
	AS3_SetS((AS3_Val) cookie, "position", zero);
	AS3_Release(zero);
	return 0;
}

FILE *baopen(AS3_Val byteArray) {
	return funopen((void *)byteArray, readByteArray, writeByteArray, seekByteArray, closeByteArray);
}
