import mx.utils.Delegate;
import caurina.transitions.Tweener;
import flash.display.BitmapData;
import flash.geom.Matrix;
import flash.geom.Rectangle;
import caurina.transitions.Equations;
import mx.containers.Window;
/**
 * @author Saqoosha
 */
class App extends MovieClip {

	/**
	 * Entry point
	 */
	public static function main(mc:MovieClip):Void {
		Stage.align = "TL";
		Stage.scaleMode = "noScale";
		mc._quality = 'BEST';  // これがポイント 1 つ目ね。
		mc._focusRect = false;
		mc.__proto__ = App.prototype;
		Function(App).apply(mc, null);
	}
	
	private var _currentIndex:Number = 1;
	private var _photo:MovieClip;
	private var _zoomRect:Rectangle;
	
	private var _qText:TextField;
	private var _qStr = ['LOW', 'MEDIUM', 'HIGH', 'BEST'];
	private var _qIdx = 0;
	
	/**
	 * Constructor
	 */
	private function App() { // こっから始まる
		this._qText = this.createTextField('q', 100, 10, 10, 100, 30);
		this._qText.setNewTextFormat(new TextFormat('Verdana', 16, 0xffffff, true));
		this._qText.text = this._quality;
		Mouse.addListener({
			onMouseDown: Delegate.create(this, this._changeQuallity) // MouseDown で _changeQuallity
		});
		this._nextPhoto(); // はじまりはじまりー
	}
	
	private function _changeQuallity():Void { // _quality 変える。
		this._quality = this._qText.text = this._qStr[this._qIdx++];
		this._qIdx = this._qIdx % 4;
	}
	
	private function _nextPhoto():Void {
		this._photo = this.createEmptyMovieClip('loader', 1); // 読み込む用のん
		this._photo._visible = false; // 見えないように
		this._photo.loadMovie('images/' + this._currentIndex +'.jpg');
		this.onEnterFrame = this._loadCheck; // 読み込みチェックしまーす
	}
	
	private function _loadCheck():Void { // 読み込みチェックしまーす
		var loaded:Number = this._photo.getBytesLoaded();
		var total:Number = this._photo.getBytesTotal();
		if (total > 0 && loaded == total) { // 読み込み完了
			delete this.onEnterFrame; // 読み込みチェックやめまーす
			var w:Number = this._photo._width;
			var h:Number = this._photo._height;
			var bm:BitmapData = new BitmapData(w, h, false, 0xf0); // BitmapData に draw しなおします。
			bm.draw(this._photo);
			this._photo.unloadMovie(); // 読み込みようのんはいらん。
			this._photo.removeMovieClip(); // 捨てます。
			this._photo = this.createEmptyMovieClip('photo', 1); // 表示用のんをあらたに作る
			this._photo._alpha = 0; // 消しとく
			this._photo._xscale = this._photo._yscale = 75; // これもポイント。100 ちょうどだとダメ。101 は OK。
			this._photo._x = Math.max(Stage.width - (w * this._photo._xscale / 100), 150);
			this._photo._y = (Stage.height - (h * this._photo._yscale / 100)) * 0.5;
			this._photo.attachBitmap(bm, 1, 'never', true); // draw したやつを attach。3番目の never とさいごの true が重要。
			Tweener.addTween(this._photo, { // フェードイン
				_alpha: 100,
				time: 5,
				transition: Equations.easeInOutCubic
			});
			Tweener.addTween(this._photo, { // ゆっくりスライド
				_x: 0,
				time: 30,
				transition: Equations.easeNone,
				onComplete: Delegate.create(this, this._cleanup) // おわったら後片づけ
			});
			Tweener.addTween(this._photo, { // フェードアウト
				_alpha: 0,
				time: 5,
				delay: 25,
				transition: Equations.easeInOutCubic
			});
		}
	}
	
	private function _cleanup():Void { // おかたずけしましょう
		if (++this._currentIndex == 5) { // 次の画像番号に
			this._currentIndex = 1;
		}
		this._nextPhoto(); // 次、はじめまーす
	}

}
