﻿package org.sazameki.audio.core 
{
	
	/**
	* ...
	* @author Takaaki Yamazaki(zk design)
	*/
	public class AudioSamples 
	{
		
		public var left:Vector.<Number>
		public var right:Vector.<Number>
		
		private var _setting:AudioSetting;
		//TODO: サンプルがmonoのときは、rightにleftのサンプルの参照を入れておくようにする？
		public function AudioSamples(setting:AudioSetting,length:int=0) 
		{
			_setting = setting;
			if (length)
			{
				left = new Vector.<Number>(length,true);
				if (setting.channels == 2)
				{
					right = new Vector.<Number>(length,true);
				}
			}else
			{
				left = new Vector.<Number>();
				if (setting.channels == 2)
				{
					right = new Vector.<Number>();
				}
			}
			
		}
		public function get length():int { return left.length; }
		public function get setting():AudioSetting { return _setting; }
		
		public function clearSamples():void
		{
			var len:int = left.length;
			if (setting.channels == 2)
			{
				left = new Vector.<Number>(len,true);
				right = new Vector.<Number>(len,true);
			}else
			{
				left = new Vector.<Number>(len,true);
			}
		}
	}
	
}