﻿/*
 * --------------------------------------
 * sazameki -- audio manipulating library
 * http://sazameki.org/
 * --------------------------------------
 * 
 * - developed by     Takaaki Yamazaki
 *                    http://www.zkdesign.jp/
 * - supported by     Spark project
 *                    http://www.libspark.org/
 */

/*
 * Licensed under the MIT License
 * 
 * Copyright (c) 2008 Takaaki Yamazaki
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package org.sazameki.audio.core {
	import flash.display.Loader;
	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.media.Sound;
	import flash.utils.ByteArray;
	import flash.utils.Endian;
	import nu.mine.flashnet.sound.core.SoundClassSwfByteCode;
	import org.sazameki.audio.events.AudioEvent;
	
	/**
	* Sound factory calss.
	* You can convert Sample array to flash.media.Sound object.
	* This class is inspired by popforge library
	* - http://code.google.com/p/popforge/
	* and based on following blog entry's ideas & codes.
	* - http://www.flashbrighton.org/wordpress/?p=9
	*  requires nu.mine.flashnet.sound.core.SoundClassSwfByteCode.
	* @author Takaaki Yamazaki(zk design)
	*/
	public class SoundFactory extends EventDispatcher {
		private var byte0:ByteArray;
		private var byte1:ByteArray;
		private var byte2:ByteArray;
		protected var loader:Loader;
		public function SoundFactory() {
			//pre render bytearray skelton
			byte0=new ByteArray();
			byte0.endian=Endian.LITTLE_ENDIAN;
			writeBytes(SoundClassSwfByteCode.soundClassSwfBytes1,byte0);
			byte1=new ByteArray();
			byte1.endian=Endian.LITTLE_ENDIAN;
			writeBytes(SoundClassSwfByteCode.soundClassSwfBytes2,byte1);
			byte2=new ByteArray();
			byte2.endian=Endian.LITTLE_ENDIAN;
			writeBytes(SoundClassSwfByteCode.soundClassSwfBytes3,byte2);
			//init loader
			loader=new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE,onCreateComplete);
		}
		private function writeBytes(src:Array,bytes:ByteArray):void{
			var len:int=src.length;
			for(var i:int=0;i<len;i++){
				bytes.writeByte(src[i]);
			}
		}
		
		public function generateSound(samples:Array,setting:AudioSetting):void{
			
			var smplNum:int=samples.length;
			var smplByteSize:int=smplNum*(setting.bitRate/8)*setting.channels;

			var swf:ByteArray=new ByteArray();
			swf.endian=Endian.LITTLE_ENDIAN;
			
			//write template0
			swf.writeBytes(byte0);
			//write total size
			swf.writeUnsignedInt(299+smplByteSize);
			//write template1
			swf.writeBytes(byte1);
			//write wave size
			swf.writeUnsignedInt(smplByteSize+7);
			swf.writeByte(1);
			swf.writeByte(0);
			//write format
			var formatByte:int=0x30;
			formatByte+=(setting.sampleRateIndex<<2)
			formatByte+=((setting.bitRate/8-1)<<1)
			formatByte+=(setting.channels-1);

			swf.writeByte(formatByte);		
			//write sample counts
			swf.writeUnsignedInt(smplNum);
			
			//write audio data
			swf.writeBytes(getSampleBytes(samples,setting));
			
			//write template3
			swf.writeBytes(byte2);
			
			convertToSound(swf);
			
		}

		protected function convertToSound(swfBytes:ByteArray):void{
			loader.loadBytes(swfBytes);
		}
		
		private function onCreateComplete(e:Event):void {
			//convert to flash.media.sound
			var soundClass:Class=Class(loader.contentLoaderInfo.applicationDomain.getDefinition("SoundClass"));
			var sound:Sound=new soundClass();
			//dispatch event
			dispatchEvent(new AudioEvent(AudioEvent.COMPLETE,sound));
		}
		
		//TODO: MORE SMART!!!
		private function getSampleBytes(samples:Array,setting:AudioSetting):ByteArray{
			
			var len:int=samples.length;
			var bytes:ByteArray=new ByteArray();
			bytes.endian=Endian.LITTLE_ENDIAN;
			var i:int;
			var s:Sample;
			var sig:Number;
			if(setting.channels==2){
				if(setting.bitRate==16){
					for(i=0;i<len;i++){
						s=samples[i];

						sig=s.left;
						if( sig < -1 ) bytes.writeShort( -32767 );
						else if( sig > 1 ) bytes.writeShort( 32767 );
						else bytes.writeShort( sig * 32767 );
						
						sig=s.right;
						if( sig < -1 ) bytes.writeShort( -32767 );
						else if( sig > 1 ) bytes.writeShort( 32767 );
						else bytes.writeShort( sig * 32767 );
					}
				}else{
					for(i=0;i<len;i++){
						s=samples[i];
						
						sig=s.left;
						if(sig<-1) bytes.writeByte(0);
						else if(sig>1) bytes.writeByte(255);
						else bytes.writeByte(sig*127+128);
						
						sig=s.right;
						if(sig<-1) bytes.writeByte(0);
						else if(sig>1) bytes.writeByte(255);
						else bytes.writeByte(sig*127+128);
						
					}
				}
			}else{
				if(setting.bitRate==16){
					for(i=0;i<len;i++){
						s=samples[i];

						sig=s.left;
						if( sig < -1 ) bytes.writeShort( -32767 );
						else if( sig > 1 ) bytes.writeShort( 32767 );
						else bytes.writeShort( sig * 32767 );
					}
				}else{
					for(i=0;i<len;i++){
						sig=s.left;
						if(sig<-1) bytes.writeByte(0);
						else if(sig>1) bytes.writeByte(255);
						else bytes.writeByte(sig*127+128);
					}
				}
				
			}
			return bytes;
			
			
		}
		
	}
	
}