﻿package org.sazameki.audio.engine.MultiSamplePlayer
{
	import flash.display.InteractiveObject;
	import org.sazameki.audio.core.AudioSamples;
	import org.sazameki.audio.ctrlEvent.CtrlEventList;
	import org.sazameki.audio.ctrlEvent.events.CtrlEvent;
	import org.sazameki.audio.ctrlEvent.events.ICtrlEvent;
	import org.sazameki.audio.ctrlEvent.events.NoteOff;
	import org.sazameki.audio.ctrlEvent.events.NoteOn;
	import org.sazameki.audio.processor.utility.LengthChanger;
	
	/**
	* multi sample player.(a kind of sampler/PCM synthesizer)
	* @author Takaaki Yamazaki(zk design)
	*/
	public class MultiSamplePlayer
	{
		
		
		public var name:String;
		
		private var _instruments:Vector.<Instrument>;
		private var _instrumentMap:Vector.<uint>
		private var _voices:Vector.<Voice>;
		
		public function MultiSamplePlayer() 
		{
			_instruments = new Vector.<Instrument>();
			_instrumentMap = new Vector.<uint>(127);
			_voices = new Vector.<Voice>();
			_instruments.push(null);
		}
		
		public function addInstrument(inst:Instrument,noteRange:NoteRange):void
		{
			var id:uint=_instruments.push(inst)-1;
			
			var max:uint = noteRange.max+1;
			
			for (var i:uint = noteRange.min; i < max; ++i)
			{
				_instrumentMap[i] = id;
			}
		}
		
		public function getInstrument(midiNoteNumber:int):Instrument
		{
			return _instruments[_instrumentMap[midiNoteNumber]];
		}
		
		public function process(data:ProcessData):void
		{
			var len:int = data.length;
			var eventList:CtrlEventList = data.events;
			var samples:AudioSamples = data.samples;
			var events:Vector.<ICtrlEvent>;
			var event:ICtrlEvent;
			var eventsLen:int;
			var i:int;
			var k:int;
			var note:int;
			
			//イベントを処理
			for ( i = 0; i < len; ++i )
			{
				events = eventList.getEvents(i);
				if (events)
				{
					eventsLen = events.length;
					for (k = 0; k < eventsLen; ++k )
					{
						event = events[k];
						
						switch(event.name)
						{
							case CtrlEvent.NOTE_ON:
								note = (event as NoteOn).note;
								var vel:Number = (event as NoteOn).velocity;
								_voices.push(new Voice(getInstrument(note),note,i,vel));
								break;
							case CtrlEvent.NOTE_OFF:
								note = (event as NoteOff).note;
								for (var m:int = 0; m < _voices.length; ++m)
								{
									if (_voices[m].note == note && _voices[m].noteOffStat==false)
									{
										_voices[m].noteOff(i);
										break;
									}
								}
								break;
							default:	
						}
					}
					eventList.clearEvent(i);
				}
			}
			//波形書き込み
			samples.clearSamples();
			
			var curVoice:Voice;
			var idx:int = 0;
			while (1)
			{
				if(idx<_voices.length){
					curVoice = _voices[idx];
					if (curVoice.finish)
					{
						_voices.splice(idx, 1);
					}else
					{
						curVoice.process(samples);
						idx++;
					}
				}else
				{
					break;
					
				}

			}
			
		}
	}
	
}