﻿/*
 * --------------------------------------
 * sazameki -- audio manipulating library
 * http://sazameki.org/
 * --------------------------------------
 * 
 * - developed by     Takaaki Yamazaki
 *                    http://www.zkdesign.jp/
 * - supported by     Spark project
 *                    http://www.libspark.org/
 */

/*
 * Licensed under the MIT License
 * 
 * Copyright (c) 2008 Takaaki Yamazaki
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */


package org.sazameki.audio.engine.ssGenerator {
	import flash.events.EventDispatcher;
	import org.sazameki.audio.engine.ssGenerator.engine.ISsEngine;
	import org.sazameki.audio.events.AudioEvent;
	import org.sazameki.audio.events.AudioProgressEvent;

	public class SsGenerator extends EventDispatcher{
		
	
		private var _engine:ISsEngine;
	
		public function SsGenerator(ssEngine:ISsEngine) {
			_engine = ssEngine;
		}

		/**
		 * 文字列で定義された内容に基づいて音を生成。
		 * どういった文字列でどういう音を生成するかはコンストラクタで_engineに指定したものによって定義される。
		 * 
		 * @param	str	効果音を定義する文字列。
		 * @param	callback	効果音生成完了したときに呼び出される関数。callback(sound:flash.media.Sound)
		 */		
		public function generateByString(str:String,wannaGenerateSoundObj:Boolean=true):void{
			_engine.parse(str);
			_engine.addEventListener(AudioEvent.COMPLETE,onComplete);
			_engine.addEventListener(AudioProgressEvent.ON_DATA,onData);
			_engine.process(wannaGenerateSoundObj);
			
		}
		
		private function onData(e:AudioProgressEvent):void 
		{
			dispatchEvent(new AudioProgressEvent(AudioProgressEvent.ON_DATA,e.data,e.setting));
		}
		
		private function onComplete(e:AudioEvent):void 
		{
			dispatchEvent(new AudioEvent(AudioEvent.COMPLETE,e.sound));
		}
				
		
	}
	
}
