﻿package org.sazameki.audio.engine.tenoran 
{
	import flash.display.Shape;
	import flash.display.Sprite;
	import org.sazameki.audio.ctrlEvent.CtrlEventList;
	import org.sazameki.audio.ctrlEvent.events.NoteOff;
	import org.sazameki.audio.ctrlEvent.events.NoteOn;
	import org.sazameki.audio.engine.MultiSamplePlayer.ProcessData;
	import org.sazameki.audio.processor.utility.LengthChanger;
	
	/**
	* ...
	* @author Takaaki Yamazaki(zk design)
	*/
	public class Tenoran extends Sprite
	{
		
		private var ui:TenoranUI
		
		 
		private var _bpm:Number = 135;
		private var _step:int = 16;
		
		private var _idx:int;
		private var _countBuffer:int;
		
		private var _swing:Number = 0.5;//0-1
		private var _noteOff:Boolean = false;
		private var _prevOn:Vector.<int>=new Vector.<int>;
		private var _map:Vector.<int>=Vector.<int>([41,40,38,36,34,33,31,29,28,26,24,17,16,15,14,13]);
		
		private var _latency:int = 400;
		public function Tenoran() 
		{
			ui= new TenoranUI(this);
			
			addChild(ui);
			_idx = 0;
			_countBuffer = 0;
			
			
		}
		
		public function processEvents(data:ProcessData):void
		{
			var len:int = data.length;
			var evnt:CtrlEventList = data.events;
			var smplRate:int = data.samples.setting.sampleRate;
			var stepBase:int = smplRate * 60 / _bpm / (_step / 4);
			var stepOdd:int = stepBase + (stepBase / 3) * _swing;
			var stepEven:int = stepBase - (stepOdd - stepBase);
			//ビートの頭を探す
			var count:int = 0;
			var oneStep:int;
			
			
			while(true){
				oneStep = (_idx % 2 == 1)?stepOdd:stepEven;
				if ((_countBuffer + len - count) < oneStep)
				{
					_countBuffer += (len-count);
					break;
				}else
				{
					count += oneStep - _countBuffer;
					if (count < 1)
					{
						count = 1;
					}
					setNoteEvent(evnt, count-1);
					nextStep();
					_countBuffer = 0;
				}
			}
		}
		
		private function setNoteEvent(event:CtrlEventList,insertIdx:int):void
		{
			var i:int;
			var len:int;

			//前回onだったNoteにNoteOff
			if(_noteOff){
				len = _prevOn.length;
				for ( i = 0; i < len; ++i)
				{
					event.addEvent(new NoteOff(_map[_prevOn[i]]), insertIdx);
				}
			}			
			//onになってるボタン探す
			var vec:Vector.<int>=ui.getOnNotes(_idx);
			len = vec.length;
			
			for (i = 0; i < len; ++i )
			{
				event.addEvent(new NoteOn(_map[vec[i]]), insertIdx);
			}
			
			_prevOn = vec;
		}

		private function nextStep():void
		{
			ui.activateLine(_idx,_latency);
			_idx++;
			if (_idx >= _step)
			{
				_idx = 0;
			}
		}
		
		public function get bpm():Number { return _bpm; }
		
		public function set bpm(value:Number):void 
		{
			_bpm = value;
		}
		
		public function get swing():Number { return _swing; }
		
		public function set swing(value:Number):void 
		{
			_swing = value;
			if (_swing > 1)
			{
				_swing = 1; 
			}else if (_swing < 0)
			{
				_swing = 0;
			}
		}
		
		public function set latency(value:int):void 
		{
			_latency = value;
		}
		
		public function get map():Vector.<int> { return _map; }
		
		public function set map(value:Vector.<int>):void 
		{
			_map = value;
		}
		
	}
	
}