﻿package org.sazameki.audio.engine.waveSlicer.algorithm 
{
	import org.sazameki.audio.core.AudioSamples;
	import org.sazameki.audio.engine.waveSlicer.Region;
	
	/**
	* ...
	* @author Takaaki Yamazaki(zk design)
	*/
	public class EvenIntervalSlice implements ISlicerAlgorithm
	{
		
		private var _devideCount:int;
		private var fadeCoeffs:Vector.<Number>=Vector.<Number>([0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9]);
		private var coeffLen:int = fadeCoeffs.length;

		public function EvenIntervalSlice(devideCount:int=16) 
		{
			_devideCount = devideCount;
		}
		
		public function slice(samples:AudioSamples):Vector.<Region>
		{
			var len:int = samples.length;
			var regionLen:int = Math.floor(len / _devideCount);
			var res:Vector.<Region>=new Vector.<Region>;
			var i:int = 0;
			
			//Lch
			for (; i < _devideCount; ++i)
			{
				var tmpRegion:Region = new Region(samples.setting);
				if(i!=_devideCount-1){
					tmpRegion.left = samples.left.slice(i * regionLen, i * regionLen + regionLen);
					if (samples.setting.channels == 2)
					{
						tmpRegion.right = samples.right.slice(i * regionLen, i * regionLen + regionLen);
					}
				}else
				{
					tmpRegion.left = samples.left.slice(i * regionLen);
					if (samples.setting.channels == 2)
					{
						tmpRegion.right = samples.right.slice(i * regionLen);
					}
				}
				deClip(tmpRegion);
				res.push(tmpRegion);
			}
			return res;
		}
		private function deClip(reg:Region):void
		{
			var i:int = 0;
			var regLast:int = reg.length-1;
			var left:Vector.<Number>=reg.left;
			for (; i < coeffLen; ++i)
			{
				left[i] = left[i] * fadeCoeffs[i];
				left[regLast - i] = left[regLast  - i] * fadeCoeffs[i];
			}
			if (reg.setting.channels == 2)
			{
				var right:Vector.<Number>=reg.right;
				for (i = 0; i < coeffLen; ++i)
				{
					right[i] = right[i] * fadeCoeffs[i];
					right[regLast - i] = right[regLast - i] * fadeCoeffs[i];
				}
			}
		}
		
	}
	
}