﻿package org.sazameki.audio.engine.waveSlicer.algorithm 
{
	import org.sazameki.audio.core.AudioSamples;
	import org.sazameki.audio.engine.waveSlicer.Region;
	
	/**
	* ...
	* @author Takaaki Yamazaki(zk design)
	*/
	public class RandomBeatSlice implements ISlicerAlgorithm
	{
		public var bpm:int = 180;

		public function slice(samples:AudioSamples):Vector.<Region>
		{
			var regions:Vector.<Region>=new Vector.<Region>();
			var idx:int=0;
			var len:int = samples.length;
			var nextMarker:int = 0;
			var tmpRegion:Region;
			var tmpLeft:Vector.<Number>
			var tmpRight:Vector.<Number>
			var sourceLeft:Vector.<Number>=samples.left;
			var sourceRight:Vector.<Number>=samples.right;
			var smplRate:int = samples.setting.sampleRate;
			var note8:int = smplRate * 60 / bpm / 2;
			var note16:int = note8 / 2;
			if (samples.setting.channels == 2)
			{
				while (true)
				{
					nextMarker += (Math.random() > 0.5)?note16:note8;
					if (nextMarker >= len)
					{
						break; 
					}
					
					tmpRegion = new Region(samples.setting);
					tmpLeft = tmpRegion.left;
					tmpRight = tmpRegion.right;
					
					while (idx < nextMarker)
					{
						tmpLeft.push(sourceLeft[idx]);
						tmpRight.push(sourceRight[idx]);
						++idx;
					}
					regions.push(tmpRegion);
				}
			}else
			{
				while (true)
				{
					nextMarker += (Math.random() > 0.5)?note16:note8;
					if (nextMarker >= len)
					{
						break; 
					}
					tmpRegion = new Region(samples.setting);
					tmpLeft = tmpRegion.left;
					
					while (idx < nextMarker)
					{
						tmpLeft.push(sourceLeft[idx]);
						++idx;
					}
					regions.push(tmpRegion);
				}
				
			}
			return regions;
		}
		
	}
	
}