﻿package org.sazameki.audio.format.riff 
{
	import flash.utils.ByteArray;
	
	/**
	* ...
	* @author Takaaki Yamazaki(zk design)
	*/
	public class LIST extends Chunk
	{
		protected var _type:String;
		protected var _chunks:Vector.<Chunk>;
		
		
		public function LIST(type:String) 
		{
			this.type = type;
			super("LIST");
		}
		
		public function get type():String { return _type; }
		
		public function set type(value:String):void 
		{
			if (value.length > 4)
			{
				value = value.substr(0, 4);
			}else if (value.length < 4)
			{
				while (value.length < 4)
				{
					value += " ";
				}
			}
			_type = value;
		}

		
		override protected function encodeData():ByteArray 
		{
			
			//prepare data
			var result:ByteArray = new ByteArray();
			//write type
			result.writeUTFBytes(_type);
			//write sub chunks
			var len:int = _chunks.length;
			for (var i:int =0 ; i < len ; ++i)
			{
				result.writeBytes(_chunks[i].toByteArray());
			}
			
			return result;
			
		}
		
		protected function splitList(bytes:ByteArray):Object
		{
			
			var obj:Object = new Object();
			var current:int;
			var currentName:String;
			//チャンクごとに分解。
			bytes.position = 0;
			bytes.endian = ENDIAN;
			//'RIFF'のときはとばす
			if (bytes.readUTFBytes(4) == 'RIFF')
			{
				bytes.readInt();
				bytes.readUTFBytes(4);//type
			}else
			{
				//戻す。
				bytes.position = 0;
			}
			//チャンク抜き出し
			while (bytes.position < bytes.length)
			{
				currentName = bytes.readUTFBytes(4);
				
				
				current = bytes.readInt();

				if (currentName == 'LIST')
				{
					currentName = bytes.readUTFBytes(4);
					current -= 4;
				}
				
				var tmpByte:ByteArray = new ByteArray();
				
				bytes.readBytes(tmpByte, 0, current);
				//currentが奇数の時は1バイト余分に取る
				if (current % 2 == 1)
				{
					bytes.readByte();
				}

				//trace(currentName);
				obj[currentName] = tmpByte;
				
				
			}
			
			return obj;
		}
		
		
	}
	
}