﻿package org.sazameki.audio.parameter 
{
	
	/**
	* ...
	* @author Takaaki Yamazaki(zk design)
	*/
	public class Parameter implements IParameter
	{
		protected var _value:Number;
		protected var _min:Number;
		protected var _max:Number;
		
		/**
		 * parameter
		 */
		public function Parameter(min:Number, max:Number) 
		{
			_min = min;
			_max = max;
		}
		
		public function set valueNormalized(value:Number):void
		{
			if (value > 1) value = 1;
			if (value < 0) value = 0;
			
			_value = _min + (_max - _min) * value;
		}
		public function get valueNormalized():Number
		{
			return (_value - _min) / (_max - _min);
		}
		
		public function get value():Number { return _value; }
		
		public function set value(value:Number):void 
		{
			if (value < min) value = _min;
			if (value > max) value = _max;
			_value = value;
		}
		
		public function get min():Number { return _min; }
		
		public function get max():Number { return _max; }
		
	}
	
}