﻿/*
 * --------------------------------------
 * sazameki -- audio manipulating library
 * http://sazameki.org/
 * --------------------------------------
 * 
 * - developed by     Takaaki Yamazaki
 *                    http://www.zkdesign.jp/
 * - supported by     Spark project
 *                    http://www.libspark.org/
 */


package org.sazameki.audio.processor.effects {
	import org.sazameki.audio.core.AudioSamples;
	import org.sazameki.audio.core.AudioSetting;
	import org.sazameki.audio.core.Sample;
	import org.sazameki.audio.engine.ssGenerator.SsAudioSetting;
	import org.sazameki.audio.parameter.Parameter;
	import org.sazameki.audio.processor.AudioProcessor;
	import org.sazameki.audio.processor.IAudioProcessor;
	import org.sazameki.audio.processor.SsAudioProcessor;
	import org.sazameki.data.RingArray;
	import org.sazameki.data.RingBuffer;

	public class Delay implements IAudioProcessor
	{
		
		private var _bufferL:RingBuffer;
		private var _bufferR:RingBuffer;
		private var _length:int;
		private var _delayTime:Parameter = new Parameter(1, 1000);
		private var _feedback:Parameter = new Parameter(0, 1);
		private var _mix:Parameter = new Parameter(0, 1);
		
		public function Delay(delayTimeMs:Number=500,feedBack:Number=0.5,mix:Number=0.3) {
			_delayTime.value = delayTimeMs;
			_feedback.value = feedBack;
			_mix.value = mix;
			//バッファサイズ＝delay timeの最大値*サンプルレート（44100)
			_bufferL = new RingBuffer(Math.ceil(_delayTime.max * 44.1));
			_bufferR = new RingBuffer(Math.ceil(_delayTime.max * 44.1));
			
		}
		/*override public function get description():String{
			return "delay effect.";
		}
		override public function get parameterFormat():String{
			return 'delay time(ms)-feedback(0-1)-wet(0-1)-[dry(0-1)]';
		}
		
		override public function initialize(setting:AudioSetting, basicParams:Array = null, additionalProcessors:Object = null):void{
			super.initialize(setting, basicParams, additionalProcessors);
			
			
			//ディレイタイムに基づいてバッファの長さ決定
			_length=int(setting.sampleRate*basicParams[0]/1000);
			_buffer=new RingArray(_length);
			
			for(var i:int=0;i<_length;i++){
				_buffer.push(new Sample());
			}
			
			//フィードバック
			_feedback=Number(basicParams[1]);
			
			//mix量
			_wet=Number(basicParams[2]);
			_dry=Number(basicParams[3]);
			
			if(isNaN(_dry)){
				_dry=1-_wet;
			}

		}
		*/
		public function process(samples:AudioSamples):void
		{
			
			var delayCount:int = _delayTime.value * 44.1;
			var feedback:Number = _feedback.value;
			var wet:Number = _mix.value;
			var dry:Number = 1 - wet;
			
			var i:int = 0;
			var len:int = samples.length;
			var left:Vector.<Number>=samples.left;
			var inputSig:Number;
			var wetSig:Number;
			for (; i < len; i++)
			{
				inputSig = left[i];
				wetSig = inputSig + _bufferL.head * feedback;
				_bufferL.setAt(delayCount, wetSig);
				left[i] = inputSig * dry + wetSig * wet;
				
				_bufferL.next();
				
			}
			if (samples.setting.channels == 2)
			{
				var right:Vector.<Number>=samples.right;
				for (i = 0; i < len; i++)
				{
					inputSig = right[i];
					wetSig = inputSig + _bufferR.head * feedback;
					_bufferR.setAt(delayCount, wetSig);
					right[i] = inputSig * dry + wetSig * wet;
					
					_bufferR.next();
					
				}

			}
			
			
			
			
		}
		
		public function get delayTime():Parameter { return _delayTime; }
		
		public function get feedback():Parameter { return _feedback; }
		
		public function get mix():Parameter { return _mix; }
		
	}
	
}
