﻿/*
 * --------------------------------------
 * sazameki -- audio manipulating library
 * http://sazameki.org/
 * --------------------------------------
 * 
 * - developed by     Takaaki Yamazaki
 *                    http://www.zkdesign.jp/
 * - supported by     Spark project
 *                    http://www.libspark.org/
 */

/*
 * Licensed under the MIT License
 * 
 * Copyright (c) 2008 Takaaki Yamazaki
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package org.sazameki.audio.processor.envelope {
	import org.sazameki.audio.core.Sample;
	import org.sazameki.audio.engine.ssGenerator.SsAudioSetting;
	import org.sazameki.audio.processor.SsAudioProcessor;

	public class DADSHR extends SsAudioProcessor implements IEnvelope{
		
		private var _envArray:Array;
		private var _envArrayLen:int;
		

		override public function initialize(setting:SsAudioSetting, params:Array = null, additionalProcessors:Object = null):void{
			super.initialize(setting, params, additionalProcessors);
			defineEnvelope(params[0],params[1],params[2],params[3],params[4],params[5]);
		}
		override public function get description():String{
			return "D(delay)ADSHR envelope"
		}
		override public function get parameterFormat():String{
			return 'delay time(ms)-attack time(ms)-sustain level(0-1)-hold time(ms)-release time(ms)'
		}
		override public function get isEnvelope():Boolean{ return true; }


		public function defineEnvelope(
				delayTimeMs:Number,
				attackTimeMs:Number,
				decayTimeMs:Number,
				sustainLv:Number,
				holdTimeMs:Number,
				releaseTimeMs:Number):void
		{
			//create an array of Envelope
			_envArray=new Array();
			
			var len:int;
			var i:int;
			var d:int;
			var f:Number;
			var _smplRate:int=_setting.sampleRate;
			//delay
			len=delayTimeMs*_smplRate/1000;
			for(i=0;i<len;i++){
				_envArray.push(0);
			}
			
			
			//attack
			len=attackTimeMs*_smplRate/1000;
			d=len-1;
			for(i=0;i<len;i++){
				_envArray.push(i/d);
			}
			
			//decay
			len=decayTimeMs*_smplRate/1000;
			d=len-1;
			f=1-sustainLv;
			for(i=0;i<len;i++){
				_envArray.push((f/d)*(d-i)+sustainLv);
			}
			
			//hold
			len=holdTimeMs*_smplRate/1000;
			for(i=0;i<len;i++){
				_envArray.push(sustainLv);
			}
			
			
			//release
			len=releaseTimeMs*_smplRate/1000;
			d=len-1;
			for(i=0;i<len;i++){
				_envArray.push(sustainLv-(sustainLv*i)/d);
			}
			_envArrayLen=_envArray.length;
			
		}
		
		override public function processAudio(samples:Array):void{
			var len:int=samples.length;
			var smpl:Sample;
			var env:Number;
			for(var i:int=0;i<len;i++){
				smpl=samples[i] as Sample;
				
				if(_idx<_envArrayLen){
					env=_envArray[_idx];
					smpl.left=smpl.left*env;
					smpl.right=smpl.right*env;
				}else{
					smpl.left=0;
					smpl.right=0;
				}
				_idx++;
			}
			
		}
		
		public function getEnvAt(idx:int):Number{
			return(_envArray[idx]);
		}
		public function get length():int{
			return(_envArrayLen);
		}
		
	}
	
}
