﻿/*
 * --------------------------------------
 * sazameki -- audio manipulating library
 * http://sazameki.org/
 * --------------------------------------
 * 
 * - developed by     Takaaki Yamazaki
 *                    http://www.zkdesign.jp/
 * - supported by     Spark project
 *                    http://www.libspark.org/
 */

/*
 * Licensed under the MIT License
 * 
 * Copyright (c) 2008 Takaaki Yamazaki
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package org.sazameki.audio.processor.envelope {
	import org.sazameki.audio.core.Sample;
	import org.sazameki.audio.core.AudioSetting;
	import org.sazameki.audio.engine.ssGenerator.SsAudioSetting;
	import org.sazameki.audio.processor.SsAudioProcessor;

	public class FreeEnv extends SsAudioProcessor implements IEnvelope {
		
		private var _envArray:Array;
		private var _lastNum:Number;
		public function FreeEnv(){
			
		}
		
		override public function initialize(setting:SsAudioSetting, basicParams:Array = null, additionalProcessors:Object = null):void{
			super.initialize(setting, basicParams, additionalProcessors);
			createEnvArray(basicParams);
		}
		override public function get description():String{
			return "Free envelope."
		}
		override public function get parameterFormat():String{
			return 'first level(0-1)-interval(ms)-second level(0-1)-interval(ms)-...-interval(ms)-last level(0-1)'
		}
		override public function get isEnvelope():Boolean{ return true; }

		private function createEnvArray(p:Array):void{
			_envArray=new Array();
			//値,間隔(ms),値,間隔(ms)の順で来るものとする。
			var len:int=p.length;
			var smplCount:int;
			var diff:Number;
			var p1:Number;
			for(var i:int=0;i<len;i=i+2){
				p1=p[i];
				//間のサンプル数を割り出す
				smplCount=_setting.sampleRate*p[i+1]/1000;
				
				//次の値との差を取る
				diff=p[i+2]-p1;
				
				//ひたすら計算してブッコミ
				for(var k:int=0;k<smplCount;++k){
					_envArray.push(p1+(diff/smplCount)*k);
				}
			}
			_lastNum=_envArray[_envArray.length-1];
		}
		
		override public function processAudio(samples:Array):void{
			var smpl:Sample;
			var len:int=samples.length;
			var val:Number;
			for(var i:int=0;i<len;++i){
				smpl=samples[i];
				val=_envArray[_idx];
				if(isNaN(val)){
					val=0
				}
				
				smpl.left=smpl.left*val;
				smpl.right=smpl.right*val;
				_idx++;
			}
		}
		
		
		public function getEnvAt(index:int):Number{
			var val:Number=_envArray[index];
			return (isNaN(val)?_lastNum:val);
		}
		public function get length():int{
			return _envArray.length;
		}
		
	}
	
}
