﻿/*
 * --------------------------------------
 * sazameki -- audio manipulating library
 * http://sazameki.org/
 * --------------------------------------
 * 
 * - developed by     Takaaki Yamazaki
 *                    http://www.zkdesign.jp/
 * - supported by     Spark project
 *                    http://www.libspark.org/
 */

/*
 * Licensed under the MIT License
 * 
 * Copyright (c) 2008 Takaaki Yamazaki
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package org.sazameki.audio.processor.filter {
	import org.sazameki.audio.core.Sample;
	import org.sazameki.audio.engine.ssGenerator.SsAudioSetting;
	import org.sazameki.audio.processor.SsAudioProcessor;
	import org.sazameki.data.RingBuffer;

	public class SimpleLPF extends SsAudioProcessor {
		
		private const STRENGTH_MAX:int=50;
		private var _bufferL:RingBuffer;
		private var _bufferR:RingBuffer;
		private var _strength:int;
		private var _prevL:Number;
		private var _prevR:Number;
		
		

		override public function initialize(setting:SsAudioSetting, basicParams:Array = null, additionalProcessors:Object = null):void{
			super.initialize(setting, basicParams, additionalProcessors);

			_bufferL=new RingBuffer();
			_bufferR=new RingBuffer();

			strength=basicParams[0];
		}
		override public function get description():String{
			return "Simple low pass filter(moving average)";
		}
		override public function get parameterFormat():String{
			return 'strength of LPF(0-1)';
		}
		public function set strength(n:Number):void{
			_strength=Math.round(n*STRENGTH_MAX);
			if(_strength==0){
				_strength=1;
			}
			_bufferL.setLength(_strength);
			_bufferR.setLength(_strength);
		}

		
		override public function processAudio(samples:Array):void{
			var len:int=samples.length;
			var smpl:Sample;

			for(var i:int=0;i<len;i++){
				smpl=samples[i];
				
				

				
				
				_bufferL.addItem(smpl.left);
				_bufferR.addItem(smpl.right);
				
				smpl.left=_bufferL.average();
				smpl.right=_bufferR.average();
			}

		}
		
	}
	
}
