﻿/*
 * --------------------------------------
 * sazameki -- audio manipulating library
 * http://sazameki.org/
 * --------------------------------------
 * 
 * - developed by     Takaaki Yamazaki
 *                    http://www.zkdesign.jp/
 * - supported by     Spark project
 *                    http://www.libspark.org/
 */

/*
 * Licensed under the MIT License
 * 
 * Copyright (c) 2008 Takaaki Yamazaki
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package org.sazameki.audio.processor.mixer {
	import org.sazameki.audio.core.Sample;
	import org.sazameki.audio.engine.ssGenerator.processor.IMasterProcessor;
	import org.sazameki.audio.engine.ssGenerator.processor.MasterProcessorReference;
	import org.sazameki.audio.engine.ssGenerator.SsAudioSetting;
	import org.sazameki.audio.processor.SsAudioProcessor;

	public class Mixer extends SsAudioProcessor{
		
		private var line0:IMasterProcessor;
		private var line1:IMasterProcessor;
		private var line0Rate:Number;
		private var line1Rate:Number;
		

		override public function initialize(setting:SsAudioSetting, basicParams:Array = null, additionalProcessors:Object = null):void{
			super.initialize(setting, basicParams, additionalProcessors);
			
			line0=MasterProcessorReference.getReference(basicParams[0]);
			line0Rate=basicParams[1];
			line1=MasterProcessorReference.getReference(basicParams[2]);
			line1Rate=basicParams[3];
			
		}
		override public function get description():String{
			return "mix 2 signals."
		}
		override public function get parameterFormat():String{
			return "line1's ID(String)-line1's mix level(0-1)-line2's ID(String)-line2's mix level(0-1)"
		}
		override public function processAudio(samples:Array):void{
			//長さは長い方にあわせる
			var arr0:Array=line0.result;
			var arr1:Array=line1.result;
			
			
			
			var len:int=Math.max(arr0.length,arr1.length);
			var smpl:Sample;
			var smpl0:Sample;
			var smpl1:Sample;
			
			var l0:Number;
			var l1:Number;
			var r0:Number;
			var r1:Number;
			
			var resultL:Number;
			var resultR:Number;
			
			
			for(var i:int=0;i<len;i++){
				smpl0=arr0[i];
				smpl1=arr1[i];
				
				if(smpl0){
					l0=smpl0.left;
					r0=smpl0.right;
				}else{
					l0=r0=0;
				}
				
				if(smpl1){
					l1=smpl1.left;
					r1=smpl1.right;
				}else{
					l1=r1=0;
				}
				resultL=l0*line0Rate+l1*line1Rate;
				resultR=r0*line0Rate+r1*line1Rate;
			    
				
				if(samples[i]){
					smpl=samples[i];
					smpl.left=resultL;
					smpl.right=resultR;
				}else{
					samples[i]=new Sample(resultL,resultR);
				}
			}
		}
		
	}
	
}
