﻿/*
 * --------------------------------------
 * sazameki -- audio manipulating library
 * http://sazameki.org/
 * --------------------------------------
 * 
 * - developed by     Takaaki Yamazaki
 *                    http://www.zkdesign.jp/
 * - supported by     Spark project
 *                    http://www.libspark.org/
 */

/*
 * Licensed under the MIT License
 * 
 * Copyright (c) 2008 Takaaki Yamazaki
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */



package org.sazameki.audio.processor.utility {
	import org.sazameki.audio.core.Sample;
	import org.sazameki.audio.engine.ssGenerator.SsAudioSetting;
	import org.sazameki.audio.processor.SsAudioProcessor;

	/**
	* Processor for change wave(sample array) length.
	* 
	* @author Takaaki Yamazaki(zk design)
	* @version 0.1
	*/
	public class LengthChanger extends SsAudioProcessor {
		
		private var _length:int;
		private var _perUpdate:int;
		

		override public function initialize(setting:SsAudioSetting,param:Array=null,obj:Object=null):void{
			super.initialize(setting,param,obj);
			
			//サンプル長の設定
			_length=param[0]*_setting.sampleRate/1000;

			if(setting.samplesPerUpdate>0){
				_perUpdate=setting.samplesPerUpdate;
			}else{
				_perUpdate=Infinity;
			}
		}	
		override public function get parameterFormat():String{
			return "length(ms)";
		}
		override public function get description():String{
			return "change wave length.";
		}
		override public function processAudio(samples:Array):void{
			var len:int=samples.length;
			
			if((_idx+len)<_length){
				//伸ばす量を決定
				
				var long:int;
				if(_perUpdate==0){
					long=_length;
				}else{
					long=Math.min(_perUpdate-len,(_length-(_idx+len)));
				}
				
				for(var i:int=0;i<long;i++){
					samples.push(new Sample());
				}
				_idx+=long;
			}
		}
		
	}
	
}
