﻿package org.sazameki.audio.utils {
	/**
	* Converter for converting MIDI note number to frequency.
	* @author Takaaki Yamazaki
	* @version 0.1
	*/
	public class Converter {
		
		private var cent:Number;
		
		public function Converter(centerAFreq:Number=440) {
			cent=centerAFreq;
		}
		
		public function MidiNoteToFreq(noteNum:int):Number{
			return(cent * Math.pow(2, (noteNum - 69)/12));
		}
		
		public function MidiNoteToFreq440(noteNum:int):Number{
			return(8.1758 * Math.pow(2,noteNum/12));
		}
		
	}
	
}
