﻿/*
 * --------------------------------------
 * sazameki -- audio manipulating library
 * http://sazameki.org/
 * --------------------------------------
 * 
 * - developed by     Takaaki Yamazaki
 *                    http://www.zkdesign.jp/
 * - supported by     Spark project
 *                    http://www.libspark.org/
 */

/*
 * Licensed under the MIT License
 * 
 * Copyright (c) 2008 Takaaki Yamazaki
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.sazameki.data {

	public class RingBuffer {
		private var _buffer:Vector.<Number>
		private var _length:int;
		private var _currentIdx:int;
		private var _sum:Number;
		
		public function RingBuffer(length:int=10) {
			_length=length;
			_buffer = new Vector.<Number>(_length);
			_currentIdx=0;
			_sum=0;
		}
		
		public function setAt(idx:int, value:Number):void
		{
			idx = _currentIdx + idx;
			while (idx > _length)
			{
				idx -= _length;
			}
			while (idx < 0)
			{
				idx += _length;
			}
			_buffer[idx] = value;
			
		}
		public function getAt(idx:int):Number
		{
			idx = _currentIdx + idx;
			while (idx >= _length)
			{
				idx -= _length;
			}
			while (idx < 0)
			{
				idx += _length;
			}
			return(_buffer[idx]);
		}
		
		public function get head():Number
		{
			return _buffer[_currentIdx];
		}
		public function set head(value:Number):void
		{
			_buffer[_currentIdx] = value;
		}
		public function next():void
		{
			_currentIdx++;
			if (_currentIdx >= _length)
			{
				_currentIdx -= _length;
			}
		}
		public function prev():void
		{
			_currentIdx--;
			if (_currentIdx < 0)
			{
				_currentIdx += _length;
			}
		}
		
		
		
		
		public function setLength(length:int,clear:Boolean=true):void{
			_length=length;
			_buffer=new Vector.<Number>(length);
			
		}
		
		public function addItem(item:Number):void{
			if(_currentIdx>=_length){
				_currentIdx=0;
			}
			_buffer[_currentIdx++]=item;
			
		}
		
		public function sum():Number{
			var n:Number=0;
			for(var i:int=0;i<_length;i++){
				n+=_buffer[i];
			}
			return(n);
		}
		
		public function average():Number{
			var n:Number=0;
			for(var i:int=0;i<_length;i++){
				if(_buffer[i]){
					n+=_buffer[i];
				}
			}
			n=n/_length
			if(isNaN(n)){
				trace("average is NaN:::"+_buffer+":::"+_length+"::n::"+n);
				return(0);
			}else{
				return(n);
			}
		}
	}
	
}
