package uranodai.oscemote.event {
	import it.h_umus.osc.OSCArgument;
	import it.h_umus.osc.OSCMessage;
	import it.h_umus.osc.OSCPacket;

	import flash.events.Event;
	import flash.geom.Point;	

	/**
	 * @author Saqoosha
	 */
	public class OSCemoteTouchEvent extends Event {

		public static const TOUCH:String = 'touch';

		private var _count:int;
		private var _position:Array;
		private var _fseq:int;

		public function OSCemoteTouchEvent(type:String, packet:OSCPacket, bubbles:Boolean = false, cancelable:Boolean = false) {
			super(type, bubbles, cancelable);
			this._count = packet.messages.length - 1;
			this._position = [];
			for (var i:int = 0; i < this._count; i++) {
				var msg:OSCMessage = packet.messages[i];
				switch (OSCArgument(msg.arguments[0]).value) {
					case 'set':
						this._position.push(new Point(
							Number(OSCArgument(msg.arguments[2]).value),
							Number(OSCArgument(msg.arguments[3]).value)
						));
						break;
					case 'fseq':
						this._fseq = int(OSCArgument(msg.arguments[1]).value);
						break;
				}
			}
		}

		public function get count():int {
			return this._count;
		}

		public function getPosition(index:int):Point {
			return this._position[index];
		}

		public function get fseq():int {
			return this.fseq;
		}
	}
}
