package net.saqoosha.sonicodeclock {
	import com.trick7.utils.TeraClock;

	import flash.display.DisplayObject;
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;	

	/**
	 * @author Saqoosha
	 */
	public class ClockDigits extends Sprite {

		public var h1:TextField;
		public var h2:TextField;
		public var c1:TextField;
		public var m1:TextField;
		public var m2:TextField;
		public var c2:TextField;
		public var s1:TextField;
		public var s2:TextField;

		private var _items:Array;
		private var _props:Array = ['hoursUpper', 'hoursLower', null, 'minutesUpper', 'minutesLower', null, 'secondsUpper', 'secondsLower'];
		private var _max:Array = [2, 9, 0, 5, 9, 0, 5, 9];

		public function ClockDigits() {
			this._items = [new Centering(this.h1),
				new Centering(this.h2),
				new Centering(this.c1),
				new Centering(this.m1),
				new Centering(this.m2),
				new Centering(this.c2),
				new Centering(this.s1),
				new Centering(this.s2)];
			for each (var c:Centering in this._items) {
				TextField(c.target).autoSize = TextFieldAutoSize.CENTER;
				c.target.y -= 2;
			}
			this.spacingX = 55;
		}

		public function update(time:TeraClock):void {
			for (var i:int = 0;i < 8; i++) {
				if (this._props[i]) {
					this._items[i].text = time[this._props[i]];
					this._items[i].y = (time[this._props[i]] - this._max[i] / 2) / (this._max[i] / 2) * 100 + Constants.CANVAS_HEIGHT_HALF;
				}
			}
		}

		public override function set rotation(value:Number):void {
			this.setProps('rotation', value);
		}

		public override function set scaleX(value:Number):void {
			this.setProps('scaleX', value);
		}

		public override function set scaleY(value:Number):void {
			this.setProps('scaleY', value);
		}

		public function set spacingX(value:Number):void {
			var prev:DisplayObject;
			for each (var c:Centering in this._items) {
				if (prev) {
					c.x = prev.x + value;
				}
				prev = c;
			}
		}

		private function setProps(prop:String, value:*):void {
			for each (var s:DisplayObject in this._items) {
				s[prop] = value;
			}
		}
	}
}

import flash.display.DisplayObject;
import flash.display.DisplayObjectContainer;
import flash.display.Sprite;
import flash.geom.Matrix;
import flash.geom.Rectangle;
import flash.text.TextField;

class Centering extends Sprite {

	private var _target:DisplayObject;

	public function Centering(target:DisplayObject) {
		this._target = target;
		this.transform.matrix = target.transform.matrix.clone();
		target.transform.matrix = new Matrix();
		target.parent.addChild(this);
		this.addChild(target);
		var bound:Rectangle = target.getBounds(target);
		target.x = -bound.width / 2;
		target.y = -bound.height / 2;
	}

	public function set text(value:String):void {
		if (this._target is TextField) {
			TextField(this._target).text = value;
		}
	}

	public function get target():DisplayObject {
		return this._target;
	}
}