package {
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.PixelSnapping;
	import flash.display.Sprite;
	import flash.display.StageQuality;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BitmapFilter;
	import flash.filters.BitmapFilterQuality;
	import flash.filters.BlurFilter;
	import flash.filters.ColorMatrixFilter;
	import flash.geom.Matrix;
	import flash.geom.Point;
	
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.core.geom.Particles;
	import org.papervision3d.core.geom.renderables.Particle;
	import org.papervision3d.materials.special.ParticleMaterial;
	import org.papervision3d.view.BasicView;
	
	[SWF(width=640, height=480, backgroundColor=0x000000, frameRate=30)]

	public class Test1 extends Sprite {
		
		private static const ZERO_POINT:Point = new Point(0, 0);
		
		[Embed(source='../assets/color1.png')]
		private static const color1Class:Class;
		private static const color1:BitmapData = Bitmap(new color1Class()).bitmapData;
		
		private var _viewport:BasicView;
		private var _particles:Particles;
		private var _canvas:BitmapData;
		private var _scaleMatrix:Matrix;
		private var _filters:Array;
		
		public function Test1() {
			this.stage.quality = StageQuality.LOW;
			
			this._canvas = new BitmapData(320, 240, false, 0x0);
			var bm:Bitmap = this.addChild(new Bitmap(this._canvas, PixelSnapping.ALWAYS, false)) as Bitmap;
			bm.scaleX = bm.scaleY = 2;
			
			this._scaleMatrix = new Matrix(0.5, 0, 0, 0.5, 0, 0);
			this._filters = [
				new BlurFilter(2, 2, BitmapFilterQuality.LOW),
				new ColorMatrixFilter([
					0.98, 0, 0, 0, 0,
					0, 0.98, 0, 0, 0,
					0, 0, 0.98, 0, 0,
					0, 0, 0, 1, 0
				]),
			];
			
			this._viewport = this.addChild(new BasicView(640, 480, false)) as BasicView;
			var c:Camera3D = this._viewport.cameraAsCamera3D;
			c.fov = 50;
			c.z = -c.focus * c.zoom;
			this._particles = this._viewport.scene.addChild(new Particles()) as Particles;
			var n:int = 100;
			var mat:ParticleMaterial = new ParticleMaterial(0xffffff, 1.0, ParticleMaterial.SHAPE_CIRCLE);
			while (n--) {
				this._particles.addParticle(new FParticle(mat));
			}
			this._viewport.startRendering();
			this.addEventListener(Event.ENTER_FRAME, this._updateParticles);
			this.addEventListener(Event.ENTER_FRAME, this._updateCanvas);
		}
		
		private function _updateParticles(e:Event):void {
			var p:FParticle;
			for each (p in this._particles.particles) {
				p.x += p.vx;
				p.y += p.vy;
				p.z += p.vz;
				p.vx *= 0.96;
				p.vy *= 0.96;
				p.vy -= 0.05;
				p.vz *= 0.96;
			}
//			p.material.fillAlpha -= 0.006;
			p.material.fillAlpha *= 0.97;
			p.material.fillColor = color1.getPixel((1 - p.material.fillAlpha) * 500, 0);
			if (p.material.fillAlpha <= 0.03) {
				p.material.fillAlpha = 0;
				this.removeEventListener(Event.ENTER_FRAME, this._updateParticles);
				this.stage.addEventListener(MouseEvent.CLICK, this._onClick);
			}
			this._particles.rotationY -= 0.3;
		}
		
		private function _updateCanvas(e:Event):void {
			this._canvas.draw(this._viewport, this._scaleMatrix);
			for each (var f:BitmapFilter in this._filters) {
				this._canvas.applyFilter(this._canvas, this._canvas.rect, ZERO_POINT, f);
			}
		}
		
		private function _onClick(e:MouseEvent):void {
			this._resetParticles();
			this.stage.removeEventListener(MouseEvent.CLICK, this._onClick);
			this.addEventListener(Event.ENTER_FRAME, this._updateParticles);
		}
		
		private function _resetParticles():void {
			var p:FParticle;
			for each (p in this._particles.particles) {
				p.reset();
			}
			p.material.fillAlpha = 1.0;
		}
		
	}
	
}


import org.papervision3d.core.geom.renderables.Particle;
import org.papervision3d.materials.special.ParticleMaterial;

class FParticle extends Particle {
	
	public var vx:Number;
	public var vy:Number;
	public var vz:Number;
	
	public function FParticle(mat:ParticleMaterial) {
		super(mat, 8, 0, 0, 0);
		this.reset();
	}
	
	public function reset():void {
		this.x = this.y = this.z = 0;
		var z:Number = Math.random() * 2 - 1;
		var phi:Number = Math.random() * Math.PI * 2;
		var r:Number = 8.8 + Math.random() * 0.2;
		this.vx = r * Math.sqrt(1 - z * z) * Math.cos(phi);
		this.vy = r * Math.sqrt(1 - z * z) * Math.sin(phi) + 4;
		this.vz = r * z;
	}
}