package {
	
	import flash.display.Sprite;
	
	import org.libspark.thread.EnterFrameThreadExecutor;
	import org.libspark.thread.Thread;

	[SWF(width=640, height=480, backgroundColor=00, frameRate=30)]

	public class Test2 extends Sprite {
		
		public function Test2() {
			Thread.initialize(new EnterFrameThreadExecutor());
			Thread.uncaughtErrorHandler = this._onUncaughtThreadError;
			new MainThread(this).start();
		}
		
		private function _onUncaughtThreadError(e:Error, th:Thread):void {
			trace(e.getStackTrace());
		}
		
	}
	
}



import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.PixelSnapping;
import flash.display.Sprite;
import flash.filters.BitmapFilter;
import flash.filters.BitmapFilterQuality;
import flash.filters.BlurFilter;
import flash.filters.ColorMatrixFilter;
import flash.geom.Matrix;
import flash.geom.Point;
import flash.media.Camera;
import flash.media.Video;
import flash.utils.ByteArray;

import org.libspark.flartoolkit.core.FLARCode;
import org.libspark.flartoolkit.core.FLARParam;
import org.libspark.flartoolkit.core.FLARTransMatResult;
import org.libspark.flartoolkit.core.raster.FLARBitmapData;
import org.libspark.flartoolkit.detector.FLARSingleMarkerDetector;
import org.libspark.flartoolkit.scene.FLARBaseNode;
import org.libspark.flartoolkit.scene.FLARCamera3D;
import org.libspark.thread.Thread;
import org.papervision3d.materials.WireframeMaterial;
import org.papervision3d.objects.primitives.Plane;
import org.papervision3d.render.LazyRenderEngine;
import org.papervision3d.scenes.Scene3D;
import org.papervision3d.view.Viewport3D;
import flash.display.BlendMode;
	
class MainThread extends Thread {
	
	private static const ZERO_POINT:Point = new Point(0, 0);
		
	private static const IMAGE_WIDTH:int = 320;
	private static const IMAGE_HEIGHT:int = 240;
	private static const MARKER_SIZE:int = 80; // mm
	
	[Embed(source='../assets/camera_para.dat', mimeType='application/octet-stream')]
	private static const cameraParamDataClass:Class;
	[Embed(source='../assets/hanabi-patt.dat', mimeType='application/octet-stream')]
	private static const markerPattDataClass:Class;
	
	private var _base:Sprite;
	private var _webcam:Camera;
	private var _video:Video;
	private var _capture:Bitmap;
	
	private var _param:FLARParam;
	private var _code:FLARCode;
	private var _raster:FLARBitmapData;
	private var _detector:FLARSingleMarkerDetector;
	private var _resultMat:FLARTransMatResult = new FLARTransMatResult();
	
	private var _viewport:Viewport3D;
	private var _camera:FLARCamera3D;
	private var _scene:Scene3D;
	private var _renderer:LazyRenderEngine;
	private var _baseNode:FLARBaseNode;

	private var _growImage:BitmapData;
	private var _scaleMatrix:Matrix;
	private var _filters:Array;
	
	public function MainThread(base:Sprite):void {
		this._base = base;
		this._base.scaleX = this._base.scaleY = 2;
	}
	
	protected override function run():void {
		// webcam
		this._webcam = Camera.getCamera();
		if (!this._webcam) {
			return;
		}
		this._webcam.setMode(IMAGE_WIDTH, IMAGE_HEIGHT, 30);
		this._video = new Video(IMAGE_WIDTH, IMAGE_HEIGHT);
		this._video.attachCamera(this._webcam);
		
		// effect layer
		this._growImage = new BitmapData(IMAGE_WIDTH, IMAGE_HEIGHT, true, 0x0);
		var b:Bitmap = this._base.addChild(new Bitmap(this._growImage, PixelSnapping.ALWAYS, false)) as Bitmap;
		b.blendMode = BlendMode.ADD;
		this._scaleMatrix = new Matrix(0.5, 0, 0, 0.5, 0, 0);
		this._filters = [
			new BlurFilter(2, 2, BitmapFilterQuality.LOW),
			new ColorMatrixFilter([
				0.98, 0, 0, 0, 0,
				0, 0.98, 0, 0, 0,
				0, 0, 0.98, 0, 0,
				0, 0, 0, 1, 0
			]),
		];
		
		// setup ARToolkit
		this._param = new FLARParam();
		this._param.loadFromARFile(ByteArray(new cameraParamDataClass()));
		this._param.changeSize(IMAGE_WIDTH, IMAGE_HEIGHT);
		this._code = new FLARCode(16, 16);
		var dat:ByteArray = new markerPattDataClass();
		this._code.loadFromARFile(dat.readUTFBytes(dat.length));
		this._capture = new Bitmap(new BitmapData(IMAGE_WIDTH, IMAGE_HEIGHT, false, 0), PixelSnapping.AUTO, true);
		this._capture.alpha = 0.35;
		this._base.addChild(this._capture);
		this._raster = new FLARBitmapData(this._capture.bitmapData);
		this._detector = new FLARSingleMarkerDetector(this._param, this._code, MARKER_SIZE);

		// setup pv3d (2.0 beta1)
		this._viewport = this._base.addChild(new Viewport3D(IMAGE_WIDTH, IMAGE_HEIGHT)) as Viewport3D;
		this._viewport.x = -4; // 4pix ???
		this._camera = new FLARCamera3D(this._param);
		this._scene = new Scene3D();
		this._baseNode = this._scene.addChild(new FLARBaseNode()) as FLARBaseNode;
		this._renderer = new LazyRenderEngine(this._scene, this._camera, this._viewport);

		var wmat:WireframeMaterial = new WireframeMaterial(0xff0000, 1);
		wmat.doubleSided = true;
		this._baseNode.addChild(new Plane(wmat, MARKER_SIZE, MARKER_SIZE));

		this._render();
	}
	
	private function _render():void {
		this._capture.bitmapData.draw(this._video);
		if (this._detector.detectMarkerLite(this._raster, 80) && this._detector.getConfidence() > 0.5) {
			this._detector.getTranslationMatrix(this._resultMat);
			this._baseNode.setTranslationMatrix(this._resultMat);
			this._baseNode.visible = true;
		} else {
			this._baseNode.visible = false;
		}
		this._renderer.render();
		
		this._growImage.draw(this._viewport);
		for each (var f:BitmapFilter in this._filters) {
			this._growImage.applyFilter(this._growImage, this._growImage.rect, ZERO_POINT, f);
		}
		
		next(this._render);
	}
	
}
