package {
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.PixelSnapping;
	import flash.display.Sprite;
	import flash.display.StageQuality;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BitmapFilter;
	import flash.filters.BitmapFilterQuality;
	import flash.filters.BlurFilter;
	import flash.filters.ColorMatrixFilter;
	import flash.geom.Matrix;
	import flash.geom.Point;
	
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.core.geom.Particles;
	import org.papervision3d.core.geom.renderables.Particle;
	import org.papervision3d.materials.special.ParticleMaterial;
	import org.papervision3d.view.BasicView;
	
	[SWF(width=640, height=480, backgroundColor=0x000000, frameRate=30)]

	public class Test3 extends Sprite {
		
		private static const ZERO_POINT:Point = new Point(0, 0);
		
		[Embed(source='../assets/color1.png')]
		private static const color1Class:Class;
		private static const color1:BitmapData = Bitmap(new color1Class()).bitmapData;
		
		private var _viewport:BasicView;
		private var _fireworks:Array;
		private var _canvas:BitmapData;
		private var _scaleMatrix:Matrix;
		private var _filters:Array;
		
		public function Test3() {
			this.stage.quality = StageQuality.LOW;
			
			this._canvas = new BitmapData(320, 240, false, 0x0);
			var bm:Bitmap = this.addChild(new Bitmap(this._canvas, PixelSnapping.ALWAYS, false)) as Bitmap;
			bm.scaleX = bm.scaleY = 2;
			
			this._scaleMatrix = new Matrix(0.5, 0, 0, 0.5, 0, 0);
			this._filters = [
				new BlurFilter(2, 2, BitmapFilterQuality.LOW),
				new ColorMatrixFilter([
					0.94, 0, 0, 0, 0,
					0, 0.95, 0, 0, 0,
					0, 0, 0.95, 0, 0,
					0, 0, 0, 1, 0
				]),
			];
			
			this._viewport = this.addChild(new BasicView(640, 480, false)) as BasicView;
			var c:Camera3D = this._viewport.cameraAsCamera3D;
			c.fov = 50;
			c.z = -c.focus * c.zoom;
			
			this._fireworks = [];
			
			this._viewport.startRendering();
			
			this.addEventListener(Event.ENTER_FRAME, this._updateFireworks);
			this.addEventListener(Event.ENTER_FRAME, this._updateCanvas);
			this.stage.addEventListener(MouseEvent.CLICK, this._onClick);
		}
		
		private function _updateFireworks(e:Event):void {
			var n:int = this._fireworks.length;
			while (n--) {
				var f:Firework = this._fireworks[n];
				f.step(0);
				if (f.isFinished) {
					this._viewport.scene.removeChild(f);
					f.destroy();
					this._fireworks.splice(n, 1);
				}
			}
		}
		
		private function _updateCanvas(e:Event):void {
			this._canvas.draw(this._viewport, this._scaleMatrix);
			for each (var f:BitmapFilter in this._filters) {
				this._canvas.applyFilter(this._canvas, this._canvas.rect, ZERO_POINT, f);
			}
		}
		
		private function _onClick(e:MouseEvent):void {
			var f:Firework = this._viewport.scene.addChild(new Firework(color1)) as Firework;
			f.x = Math.random() * 200 - 100;
			f.y = Math.random() * 200 - 100;
			f.z = Math.random() * 200 - 100;
			f.start();
			this._fireworks.push(f);
		}
		
	}
	
}


import org.papervision3d.core.geom.renderables.Particle;
import org.papervision3d.materials.special.ParticleMaterial;
import org.papervision3d.core.geom.Particles;
import flash.display.BitmapData;
import org.papervision3d.core.geom.renderables.Vertex3D;
import org.papervision3d.core.math.Number3D;

class FParticle extends Particle {
	
	public var vx:Number;
	public var vy:Number;
	public var vz:Number;
	
	private var _speed:Number;
	
	public function FParticle(mat:ParticleMaterial, scale:Number = 1.0, speed:Number = 8) {
		super(mat, 8 * scale, 0, 0, 0);
		this._speed = speed;
//		this.reset();
	}
	
//	public function reset():void {
//		this.x = this.y = this.z = 0;
//		var z:Number = Math.random() * 2 - 1;
//		var phi:Number = Math.random() * Math.PI * 2;
//		this.vx = this._speed * Math.sqrt(1 - z * z) * Math.cos(phi);
//		this.vy = this._speed * Math.sqrt(1 - z * z) * Math.sin(phi);
//		this.vz = this._speed * z;
//	}

}


class Firework extends Particles {
	
	private var _mat:ParticleMaterial;
	private var _color:BitmapData;
	private var _isFinisded:Boolean;
	
	public function Firework(color:BitmapData) {
		super(null);
		this._color = color;
		this._mat = new ParticleMaterial(0xffffff, 0.5 + Math.random(), ParticleMaterial.SHAPE_CIRCLE);
		var sp:Number = 4 + Math.random() * 4;
		for each (var v:Vertex3D in new GeosphereVertices(1.0, Math.floor(Math.random() * 3) + 1).vertices) {
			var p:FParticle = new FParticle(this._mat, 1.0, sp);
			p.vx = v.x * sp;
			p.vy = v.y * sp;
			p.vz = v.z * sp;
			this.addParticle(p);
		}
	}
	
	public function start():void {
//		for each (var p:FParticle in this.particles) {
//			p.reset();
//		}
		this._mat.fillAlpha = 1.0;
		this._isFinisded = false;
	}
	
	public function step(dt:Number):void {
		var p:FParticle;
		for each (p in this.particles) {
			p.x += p.vx;
			p.y += p.vy;
			p.z += p.vz;
			p.vx *= 0.96;
			p.vy *= 0.96;
			p.vy -= 0.03;
			p.vz *= 0.96;
		}
		this._mat.fillAlpha *= 0.97;
		this._mat.fillColor = this._color.getPixel((1 - this._mat.fillAlpha) * this._color.width, 0);
		if (this._mat.fillAlpha <= 0.03) {
			this._mat.fillAlpha = 0;
			this._isFinisded = true;
		}
	}
	
	public function get isFinished():Boolean { 
		return this._isFinisded;
	}
	
	public function destroy():void {
		this.removeAllParticles();
		this._mat = undefined;
		this._color = undefined;
	}
	
}

class GeosphereVertices {
	
	private static const MIN_SEGMENTS:uint = 1;
	private static const DEFAULT_SEGMENTS:uint = 3;
	private static const DEFAULT_RADIUS:Number = 100;
	
	private var _segments:uint;
	private var _vertices:Array;
		
	public function GeosphereVertices(radius:Number = 1.0, segments:uint = 1) {
		this._segments = Math.max(MIN_SEGMENTS, segments || DEFAULT_SEGMENTS); // Defaults to 8
		if (radius == 0)	radius = DEFAULT_RADIUS; // Defaults to 100
		this.buildGeosphere(radius);
	}
	
	private function buildGeosphere(radius:Number):void {
		var nsections:uint = 20;
		var subrad:Number, subz:Number, theta:Number, sn:Number, cs:Number;
		var i:int, f:int;
		
		var aVertice:Array = this._vertices = [];

		// get first 12 Vertices //
		aVertice.push(new Vertex3D(0, 0, radius));
		subz = Math.sqrt(0.2) * radius;
		subrad = 2 * subz;
		for (i = 0; i < 5; i++) {
			theta = 2 * Math.PI * i / 5;
			sn = Math.sin (theta);
			cs = Math.cos (theta);
			aVertice.push(new Vertex3D(subrad * cs, subrad * sn, subz));
		}
		for (i = 0; i < 5; i++) {
			theta = Math.PI * (2 * i + 1) / 5;
			sn = Math.sin (theta);
			cs = Math.cos (theta);
			aVertice.push(new Vertex3D(subrad * cs, subrad * sn, -subz));
		}
		aVertice.push(new Vertex3D(0, 0, -radius));
		
		// tessellate triangles
		for (i = 0; i < 5 ; i++) interpolate(0, i + 1, this._segments);
		for (i = 0; i < 5 ; i++) interpolate(i + 1, (i + 1) % 5 + 1, this._segments);
		for (i = 0; i < 5 ; i++) interpolate(i + 1, i + 6, this._segments);
		for (i = 0; i < 5 ; i++) interpolate(i + 1, (i + 4) % 5 + 6, this._segments);
		for (i = 0; i < 5 ; i++) interpolate(i + 6, (i + 1) % 5 + 6, this._segments);
		for (i = 0; i < 5 ; i++) interpolate(11, i + 6, this._segments);
		for (f = 0; f < 5 ; f++) {
			for (i = 1; i <= this._segments - 2; i++) {
				interpolate(12 + f * (this._segments - 1) + i, 12 + ((f + 1) % 5) * (this._segments - 1) + i, i + 1);
			}
		}
		for (f = 0; f < 5 ; f++) {
			for (i = 1; i <= this._segments - 2 ; i++) {
				interpolate(12 + (f + 15) * (this._segments - 1) + i, 12 + (f + 10) * (this._segments - 1) + i, i + 1);
			}
		}
		for (f = 0; f < 5 ; f++) {
			for (i = 1; i <= this._segments - 2 ; i++) {
				interpolate(12 + (((f + 1) % 5) + 15) * (this._segments - 1) + this._segments - 2 - i, 12 + (f + 10) * (this._segments - 1) + this._segments - 2 - i, i + 1);
			}
		}
		for (f = 0; f < 5 ; f++) {
			for (i = 1; i <= this._segments - 2 ; i++) {
				interpolate(12 + (((f + 1) % 5) + 25) * (this._segments - 1) + i, 12 + (f + 25) * (this._segments - 1) + i, i + 1);
			}
		}
	}
	
	private function interpolate(v1:uint, v2:uint, num:uint):void {
		if (this._segments < 2) return;
		var aVertice:Array = this._vertices;
		var a:Vertex3D = aVertice[v1];
		var b:Vertex3D = aVertice[v2];
		var rad:Number = Number3D.dot(a.toNumber3D(), a.toNumber3D());
		var cs:Number = Number3D.dot(a.toNumber3D(), b.toNumber3D()) / rad;
		cs = (cs < -1) ? -1 : (cs > 1) ? 1 : cs;
		var theta:Number = Math.acos(cs);
		var sn:Number = Math.sin(theta);
		for (var e:int = 1; e <= num - 1; e++) {
			var np:Vertex3D = new Vertex3D();
			var theta1:Number = (theta * e) / num;
			var theta2:Number = (theta * (num - e)) / num;
			var st1:Number = Math.sin(theta1);
			var st2:Number = Math.sin(theta2);
			np.x = (a.x * st2 + b.x * st1) / sn;
			np.y = (a.y * st2 + b.y * st1) / sn;
			np.z = (a.z * st2 + b.z * st1) / sn;
			aVertice.push(np);
		}
	}
	
	public function get vertices():Array {
//		trace('Num vertices:', this._vertices.length);
		return this._vertices;
	}
	
}


