package net.saqoosha.foyh {
	
	import caurina.transitions.Equations;
	
	import flash.utils.getTimer;
	
	import org.libspark.thread.Thread;
	import org.libspark.thread.threads.tweener.TweenerThread;
	import org.libspark.thread.utils.ParallelExecutor;

	public class FireworkThread extends Thread {
		
		private static const FRAME_TIME_MSEC:Number = 1000 / 30; // 30 fps
		
		private var _firework:Firework;
		private var _prev:int;
		private var _dt:Number;
		
		public function FireworkThread(firework:Firework) {
			this._firework = firework;
			this._firework.visible = false;
		}
		
		protected override function run():void {
			this._firework.visible = true;
			var anime:ParallelExecutor = new ParallelExecutor();
			var h:Number = 80 + Math.random() * 40;
			var s:Number = h / 35;
			anime.addThread(new TweenerThread(this._firework, {
				z: h,
				time: s,
				transition: Equations.easeOutSine
			}));
			anime.addThread(new TweenerThread(this._firework, {
				fillAlpha: 0,
				delay: s - 1.4,
				time: 1.2,
				transition: Equations.easeNone
			}));
			anime.start();
			anime.join();
			next(this._explode);
		}
		
		private function _explode():void {
			this._firework.explode();
			this._prev = getTimer();
			this._dt = 0;
			this._step();
		}
		
		private function _step():void {
			var now:int = getTimer();
			this._dt += now - this._prev;
			this._prev = now;
			while (this._dt > FRAME_TIME_MSEC && !this._firework.isFinished) {
				this._dt -= FRAME_TIME_MSEC;
				this._firework.step();
			}
			
			if (!this._firework.isFinished) {
				next(this._step);
			}
		}
		
		protected override function finalize():void {
			this._firework.parent.removeChild(this._firework);
			this._firework.destroy();
			this._firework = undefined;
		}
		
	}
	
}