package net.saqoosha.foyh {
	
	import caurina.transitions.Equations;
	import caurina.transitions.Tweener;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BlendMode;
	import flash.display.PixelSnapping;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BitmapFilterQuality;
	import flash.filters.BlurFilter;
	import flash.filters.ColorMatrixFilter;
	import flash.media.Camera;
	import flash.media.Video;
	import flash.utils.ByteArray;
	
	import org.libspark.flartoolkit.core.FLARCode;
	import org.libspark.flartoolkit.core.FLARParam;
	import org.libspark.flartoolkit.core.raster.FLARBitmapData;
	import org.libspark.flartoolkit.detector.FLARSingleMarkerDetector;
	import org.libspark.flartoolkit.scene.FLARBaseNode;
	import org.libspark.flartoolkit.scene.FLARCamera3D;
	import org.libspark.thread.Thread;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.render.LazyRenderEngine;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.view.Viewport3D;
	
	public class MainThread extends Thread {
		
		private static const IMAGE_WIDTH:int = 320;
		private static const IMAGE_HEIGHT:int = 240;
		private static const MARKER_SIZE:int = 80; // mm
		
		[Embed(source='../assets/camera_para.dat', mimeType='application/octet-stream')]
		private static const cameraParamDataClass:Class;
		[Embed(source='../assets/hanabi-patt.dat', mimeType='application/octet-stream')]
		private static const markerPattDataClass:Class;
		
		private var _ctx:Context;
		private var _renderThread:RenderThread;
		
		private var _base:Sprite;
		private var _webcam:Camera;
		
		private var _param:FLARParam;
		private var _code:FLARCode;
		
		private var _camera:FLARCamera3D;
		private var _scene:Scene3D;
	
		
		public function MainThread(base:Sprite) {
			this._base = base;
			this._base.scaleX = -2.0;
			this._base.scaleY = 2.0;
			this._base.x = 640;
		}
		
		protected override function run():void {
			this._ctx = new Context();
			
			// webcam
			this._webcam = Camera.getCamera();
			if (!this._webcam) {
				return;
			}
			this._webcam.setMode(IMAGE_WIDTH, IMAGE_HEIGHT, 30);
			this._ctx.video = new Video(IMAGE_WIDTH, IMAGE_HEIGHT);
			this._ctx.video.attachCamera(this._webcam);
			
			// effect layer
			this._ctx.growImage = new BitmapData(IMAGE_WIDTH, IMAGE_HEIGHT, true, 0x0);
			var b:Bitmap = this._base.addChild(new Bitmap(this._ctx.growImage, PixelSnapping.ALWAYS, false)) as Bitmap;
			b.blendMode = BlendMode.ADD;
			this._ctx.filters = [
				new BlurFilter(2, 2, BitmapFilterQuality.LOW),
				new ColorMatrixFilter([
					0.98, 0, 0, 0, 0,
					0, 0.98, 0, 0, 0,
					0, 0, 0.98, 0, 0,
					0, 0, 0, 1, 0
				]),
			];
			
			// setup ARToolkit
			this._param = new FLARParam();
			this._param.loadFromARFile(ByteArray(new cameraParamDataClass()));
			this._param.changeSize(IMAGE_WIDTH, IMAGE_HEIGHT);
			this._code = new FLARCode(16, 16);
			var dat:ByteArray = new markerPattDataClass();
			this._code.loadFromARFile(dat.readUTFBytes(dat.length));
			this._ctx.capture = new Bitmap(new BitmapData(IMAGE_WIDTH, IMAGE_HEIGHT, false, 0), PixelSnapping.AUTO, true);
//			this._ctx.capture.alpha = 0.35;
			this._base.addChild(this._ctx.capture);
			this._ctx.raster = new FLARBitmapData(this._ctx.capture.bitmapData);
			this._ctx.detector = new FLARSingleMarkerDetector(this._param, this._code, MARKER_SIZE);
	
			// setup pv3d (2.0 beta1)
			this._ctx.viewport = this._base.addChild(new Viewport3D(IMAGE_WIDTH, IMAGE_HEIGHT)) as Viewport3D;
			this._ctx.viewport.x = -3.5; // 4pix ???
			this._camera = new FLARCamera3D(this._param);
			this._scene = new Scene3D();
			this._ctx.baseNode = this._scene.addChild(new FLARBaseNode()) as FLARBaseNode;
			this._ctx.renderer = new LazyRenderEngine(this._scene, this._camera, this._ctx.viewport);
	
//			this._ctx.baseNode.addChild(new UCS(MARKER_SIZE));
//			var wmat:WireframeMaterial = new WireframeMaterial(0xffffff, 0.1);
//			wmat.doubleSided = true;
//			this._ctx.baseNode.addChild(new Plane(wmat, MARKER_SIZE, MARKER_SIZE));
	
			this._renderThread = new RenderThread(this._ctx);
			this._renderThread.start();
			
			this._waitEvent();
		}
		
		private function _waitEvent():void {
			event(this._base.stage, MouseEvent.CLICK, this._onClickStage);
			event(this._renderThread, RenderThread.DETECTED_EVENT, this._onDetected);
			event(this._renderThread, RenderThread.LOST_EVENT, this._onLost);
		}
		
		private function _onClickStage(e:MouseEvent):void {
			var f:Firework = new Firework();
			f.x = Math.random() * MARKER_SIZE - MARKER_SIZE * 0.5;
			f.y = Math.random() * MARKER_SIZE - MARKER_SIZE * 0.5;
			this._ctx.baseNode.addChild(f);
			var ft:FireworkThread = new FireworkThread(f);
			ft.start();
			this._waitEvent();
		}
		
		private function _onDetected(e:Event):void {
			Tweener.removeTweens(this._ctx.capture);
			Tweener.addTween(this._ctx.capture, {
				alpha: 0.25,
				delay: 0.5,
				time: 1,
				transition: Equations.easeInOutCubic
			});
			this._waitEvent();
		}
		
		private function _onLost(e:Event):void {
			Tweener.removeTweens(this._ctx.capture);
			Tweener.addTween(this._ctx.capture, {
				alpha: 1,
				delay: 0.5,
				time: 1,
				transition: Equations.easeInOutCubic
			});
			this._waitEvent();
		}

	}
	
}