package net.saqoosha.foyh {
 	
	import flash.events.Event;
	import flash.filters.BitmapFilter;
	import flash.geom.Point;
	
	import org.libspark.thread.utils.EventDispatcherThread;

	public class RenderThread extends EventDispatcherThread {
		
		public static const DETECTED_EVENT:String = 'detected';
		public static const LOST_EVENT:String = 'lost';
		
		private static const ZERO_POINT:Point = new Point(0, 0);
			
		private var ctx:Context;
		private var _detected:Boolean;
		
		public function RenderThread(ctx:Context) {
			this.ctx = ctx;
			this._detected = false;
		}
		
		protected override function run():void {
			this.ctx.capture.bitmapData.draw(this.ctx.video);
			if (this.ctx.detector.detectMarkerLite(this.ctx.raster, 80) && this.ctx.detector.getConfidence() > 0.5) {
				this.ctx.detector.getTranslationMatrix(this.ctx.resultMat);
				this.ctx.baseNode.setTranslationMatrix(this.ctx.resultMat);
				this.ctx.baseNode.visible = true;
			} else {
				this.ctx.baseNode.visible = false;
			}
			this.ctx.renderer.render();
			
			this.ctx.growImage.draw(this.ctx.viewport, this.ctx.viewport.transform.matrix);
			for each (var f:BitmapFilter in this.ctx.filters) {
				this.ctx.growImage.applyFilter(this.ctx.growImage, this.ctx.growImage.rect, ZERO_POINT, f);
			}
			
			if (this._detected != this.ctx.baseNode.visible) {
				this._detected = this.ctx.baseNode.visible;
				this.dispatchEvent(new Event(this._detected ? DETECTED_EVENT : LOST_EVENT));
			}
			
			next(this.run);
		}
		
		public function get detected():Boolean {
			return this._detected;
		}
		
	}
	
}