package net.saqoosha.util {

	public class ColorUtil {
		
		/**
		 * Convert HSV color to RGB color int
		 * @param h	Hue (0-360)
		 * @param s	Satuation (0-1)
		 * @param	v	Value (0-1)
		 * @return	int
		 */
		public static function HSV2int(h:Number, s:Number, v:Number):int {
			var r:Number, g:Number, b:Number;
			const i:Number = Math.floor((h / 60) % 6);
			const f:Number = (h / 60) - i;
			const p:Number = v * (1 - s);
			const q:Number = v * (1 - f * s);
			const t:Number = v * (1 - (1 - f) * s);
			switch(i) {
				case 0: r=v; g=t; b=p; break;
				case 1: r=q; g=v; b=p; break;
				case 2: r=p; g=v; b=t; break;
				case 3: r=p; g=q; b=v; break;
				case 4: r=t; g=p; b=v; break;
				case 5: r=v; g=p; b=q; break;
			}
			return (int(r * 0xff) << 16) | (int(g * 0xff) << 8) | int(b * 0xff);
		}
		
		/**
		 * Convert RGB color to HSV color
		 * @param r	Red (0-255)
		 * @param g	Green (0-255)
		 * @param	b	Blue (0-255)
		 * @return	HSV color object
		 */
		public static function RGB2HSV(red:int, green:int, blue:int):Object {
			var hsvArr:Array = new Array();
			var rr:Number = red / 255;
			var gg:Number = green / 255;
			var bb:Number = blue / 255;
			
			var myMax:Number = Math.max(rr, Math.max(gg, bb));
			var myMin:Number = Math.min(rr, Math.min(gg, bb));
			var v:Number = myMax;
			var s:Number;
			var h:Number;
			if (myMax > 0) {
				s = (myMax - myMin) / myMax;
			}
			else {
				s = 0;
			}
			if (s > 0) {
				var myDiff:Number = myMax - myMin;
				var rc:Number = (myMax - rr) / myDiff;
				var gc:Number = (myMax - gg) / myDiff;
				var bc:Number = (myMax - bb) / myDiff;
				if (rr == myMax) {
					h = (bc - gc) / 6;
				}
				if (gg == myMax) {
					h = (2 + rc - bc) / 6;
				}
				if (bb == myMax) {
					h = (4 + gc - rc) / 6;
				}
			}
			else {
				h = 0;
			}
			if (h < 0) {
				h += 1;
			}
			return { h:h * 360, s:s, v:v};
		}
		
		public static function int2HSV(col:int):Object {
			return ColorUtil.RGB2HSV(col >> 16 & 0xff, col >> 8 & 0xff, col & 0xff);
		}
		
		/**
		 * Adjust contrast
		 * @param color	Color value (int)
		 * @param contrast	Contrast (-1 to 1)
		 * @return	int
		 */
		public static function adjustContrast(color:int, contrast:Number):int {
			var r:Number = (color >> 16) & 0xff;
			var g:Number = (color >> 8) & 0xff;
			var b:Number = color & 0xff;
			var c:Number = 1 + contrast;
			var o:Number = 127 * -contrast;
			r = Math.max(0, Math.min(255, int(r * c + o)));
			g = Math.max(0, Math.min(255, int(g * c + o)));
			b = Math.max(0, Math.min(255, int(b * c + o)));
			return (r << 16) | (g << 8) | b;
		}
	
//		/**
//		 * Convert HSV color to RGB color
//		 * @param h	Hue (0-360)
//		 * @param s	Satuation (0-1)
//		 * @param	v	Value (0-1)
//		 * @return	RGB color object
//		 */
//		public static function hsv2rgb(h:Number, s:Number, v:Number):Object { 
//			var r:Number, g:Number, b:Number;
//			
//			var i:Number = Math.floor((h/60)%6);
//			var f:Number = (h/60)-i;
//			var p:Number = v*(1-s);
//			var q:Number = v*(1-f*s);
//			var t:Number = v*(1-(1-f)*s);
//			
//			switch(i) {
//				case 0: r=v; g=t; b=p; break;
//				case 1: r=q; g=v; b=p; break;
//				case 2: r=p; g=v; b=t; break;
//				case 3: r=p; g=q; b=v; break;
//				case 4: r=t; g=p; b=v; break;
//				case 5: r=v; g=p; b=q; break;
//			}
//			
//			return { r:Math.round(r*255), g:Math.round(g*255), b:Math.round(b*255) };
//		}
//	
//		public static function HSV2int(h:Number, s:Number, v:Number):int {
//			var rgb:Object = ColorUtil.hsv2rgb(h, s, v);
//			return rgb.r << 16 | rgb.g << 8 | rgb.b;
//		}
//		
//		public static function blendRGBNumber(c1:Number, c2:Number, ratio:Number):Number {
//			var rt1:Number = (typeof(ratio) == 'number') ? Math.max(0, Math.min(1.0, ratio)) : 0.5;
//			var rt2:Number = (1.0 - rt1);
//			var r:Number = Math.floor((c1 >> 16 & 0xff) * rt1 + (c2 >> 16 & 0xff) * rt2);
//			var g:Number = Math.floor((c1 >> 8 & 0xff) * rt1 + (c2 >> 8 & 0xff) * rt2);
//			var b:Number = Math.floor((c1 & 0xff) * rt1 + (c2 & 0xff) * rt2);
//			return r << 16 | g << 8 | b;
//		}
//		
//	//	public static function RGB2Number(r:Number, g:Number, b:Number):Number {
//	//		return r << 16 | g << 8 | b;
//	//	}
//		
//		public static function randomHSV2number(hmin:Number, hmax:Number, smin:Number, smax:Number, vmin:Number, vmax:Number):Number {
//			var rgb:Object = ColorUtil.hsv2rgb(hmin + (hmax - hmin) * Math.random(), smin + (smax - smin) * Math.random(), vmin + (vmax - vmin) * Math.random());
//			return rgb.r << 16 | rgb.g << 8 | rgb.b;
//		}
//		
//		public static function randomHSVVariation(rgb:Number, rangeH:Number, rangeS:Number, rangeV:Number):Number {
//			var hsv:Object = ColorUtil.RGBNumber2HSV(rgb);
//			if (rangeH) {
//				hsv.h = (hsv.h + Math.random() * rangeH + 360) % 360;
//			}
//			if (rangeS) {
//				hsv.s = Math.max(0, Math.min(1, hsv.s + Math.random() * rangeS));
//			}
//			if (rangeV) {
//				hsv.v = Math.max(0, Math.min(1, hsv.v + Math.random() * rangeV));
//			}
//			return ColorUtil.HSV2RGBNumber(hsv.h, hsv.s, hsv.v);
//		}
		
	}
	
}