window.onload = -> new GuruGuru()
    
class GuruGuru
    constructor: ->
        @init()
        @animate()
    
    init: =>
        if !Detector.webgl then Detector.addGetWebGLMessage()
    
        container = document.getElementById 'canvas'
    
        @camera = new THREE.Camera
        @camera.position.z = 1
    
        @scene = new THREE.Scene
        
        @video = document.getElementById 'video'
        @texture = new THREE.Texture @video
        @texture.minFilter = THREE.LinearFilter
        @texture.magFilter = THREE.LinearFilter
        @texture.wrapS = THREE.RepeatWrapping
        @texture.wrapT = THREE.RepeatWrapping
        
        @uniforms = 
            texture:
                type: 't'
                value: 0
                texture: @texture
            aspectRatio:
                type: 'f'
                value: 0
            hFoV:
                type: 'f'
                value: 90 * (Math.PI / 180)
            rotationMatrix:
                type: 'm4'
                value: new THREE.Matrix4

        material = new THREE.ShaderMaterial
            uniforms: @uniforms
            vertexShader: document.getElementById('vertexShader').textContent
            fragmentShader: document.getElementById('fragmentShader').textContent
        
        mesh = new THREE.Mesh(new THREE.PlaneGeometry(2, 2), material)
        @scene.add mesh
        
        @renderer = new THREE.WebGLRenderer
        container.appendChild @renderer.domElement
        
        window.addEventListener 'resize', @onWindowResize, false
        @onWindowResize()

        @rotation = new THREE.Vector3
        @mouseX = 0
        @mouseY = 0
        @offsetX = 0
        @offsetY = 0
        document.addEventListener 'mousemove', @onMouseMove, false
        
        @mousePressed = false
        document.addEventListener 'mousedown', @onMouseDown, false
        document.addEventListener 'mouseup', @onMouseUp, false
        
        @fov = 120
        @gui = new DAT.GUI
        @gui.add(@, 'fov').min(10).max(170)
        
        @stats = new Stats
        @stats.domElement.style.position = 'absolute'
        @stats.domElement.style.top = '0px'
        container.appendChild @stats.domElement
    
    onWindowResize: =>
        @uniforms.aspectRatio.value = window.innerHeight / window.innerWidth
        @renderer.setSize window.innerWidth, window.innerHeight
    
    onMouseMove: (event) =>
        @mouseX = event.pageX
        @mouseY = event.pageY
    
    onMouseDown: (event) =>
        @offsetX = event.pageX
        @offsetY = event.pageY
        @mousePressed = true
    
    onMouseUp: (event) =>
        @mousePressed = false
        
    animate: =>
        requestAnimationFrame @animate
        @render()
        @stats.update()
        
    render: =>
        @uniforms.hFoV.value = @fov * (Math.PI / 180)
        
        if @video.readyState == @video.HAVE_ENOUGH_DATA
            @texture.needsUpdate = true

        if @mousePressed
            @rotation.x += (@mouseY - @offsetY) / 1000 * 0.05
            @rotation.y -= (@mouseX - @offsetX) / 1000 * 0.05
            @uniforms.rotationMatrix.value.setRotationFromEuler @rotation

        @renderer.render @scene, @camera
