(function() {
  var GuruGuru;
  var __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  window.onload = function() {
    return new GuruGuru();
  };
  GuruGuru = (function() {
    function GuruGuru() {
      this.render = __bind(this.render, this);
      this.animate = __bind(this.animate, this);
      this.onMouseUp = __bind(this.onMouseUp, this);
      this.onMouseDown = __bind(this.onMouseDown, this);
      this.onMouseMove = __bind(this.onMouseMove, this);
      this.onWindowResize = __bind(this.onWindowResize, this);
      this.init = __bind(this.init, this);      this.init();
      this.animate();
    }
    GuruGuru.prototype.init = function() {
      var container, material, mesh;
      if (!Detector.webgl) {
        Detector.addGetWebGLMessage();
      }
      container = document.getElementById('canvas');
      this.camera = new THREE.Camera;
      this.camera.position.z = 1;
      this.scene = new THREE.Scene;
      this.video = document.getElementById('video');
      this.texture = new THREE.Texture(this.video);
      this.texture.minFilter = THREE.LinearFilter;
      this.texture.magFilter = THREE.LinearFilter;
      this.texture.wrapS = THREE.RepeatWrapping;
      this.texture.wrapT = THREE.RepeatWrapping;
      this.uniforms = {
        texture: {
          type: 't',
          value: 0,
          texture: this.texture
        },
        aspectRatio: {
          type: 'f',
          value: 0
        },
        hFoV: {
          type: 'f',
          value: 90 * (Math.PI / 180)
        },
        rotationMatrix: {
          type: 'm4',
          value: new THREE.Matrix4
        }
      };
      material = new THREE.ShaderMaterial({
        uniforms: this.uniforms,
        vertexShader: document.getElementById('vertexShader').textContent,
        fragmentShader: document.getElementById('fragmentShader').textContent
      });
      mesh = new THREE.Mesh(new THREE.PlaneGeometry(2, 2), material);
      this.scene.add(mesh);
      this.renderer = new THREE.WebGLRenderer;
      container.appendChild(this.renderer.domElement);
      window.addEventListener('resize', this.onWindowResize, false);
      this.onWindowResize();
      this.rotation = new THREE.Vector3;
      this.mouseX = 0;
      this.mouseY = 0;
      this.offsetX = 0;
      this.offsetY = 0;
      document.addEventListener('mousemove', this.onMouseMove, false);
      this.mousePressed = false;
      document.addEventListener('mousedown', this.onMouseDown, false);
      document.addEventListener('mouseup', this.onMouseUp, false);
      this.fov = 120;
      this.gui = new DAT.GUI;
      this.gui.add(this, 'fov').min(10).max(170);
      this.stats = new Stats;
      this.stats.domElement.style.position = 'absolute';
      this.stats.domElement.style.top = '0px';
      return container.appendChild(this.stats.domElement);
    };
    GuruGuru.prototype.onWindowResize = function() {
      this.uniforms.aspectRatio.value = window.innerHeight / window.innerWidth;
      return this.renderer.setSize(window.innerWidth, window.innerHeight);
    };
    GuruGuru.prototype.onMouseMove = function(event) {
      this.mouseX = event.pageX;
      return this.mouseY = event.pageY;
    };
    GuruGuru.prototype.onMouseDown = function(event) {
      this.offsetX = event.pageX;
      this.offsetY = event.pageY;
      return this.mousePressed = true;
    };
    GuruGuru.prototype.onMouseUp = function(event) {
      return this.mousePressed = false;
    };
    GuruGuru.prototype.animate = function() {
      requestAnimationFrame(this.animate);
      this.render();
      return this.stats.update();
    };
    GuruGuru.prototype.render = function() {
      this.uniforms.hFoV.value = this.fov * (Math.PI / 180);
      if (this.video.readyState === this.video.HAVE_ENOUGH_DATA) {
        this.texture.needsUpdate = true;
      }
      if (this.mousePressed) {
        this.rotation.x += (this.mouseY - this.offsetY) / 1000 * 0.05;
        this.rotation.y -= (this.mouseX - this.offsetX) / 1000 * 0.05;
        this.uniforms.rotationMatrix.value.setRotationFromEuler(this.rotation);
      }
      return this.renderer.render(this.scene, this.camera);
    };
    return GuruGuru;
  })();
}).call(this);
