package {

	import br.com.stimuli.loading.BulkLoader;
	import br.com.stimuli.loading.BulkProgressEvent;

	import cmodule.Julius.CLibInit;

	import sh.saqoo.debug.ObjectDumper;

	import com.bit101.components.HBox;
	import com.bit101.components.ProgressBar;
	import com.bit101.components.PushButton;
	import com.bit101.components.VBox;

	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.net.FileFilter;
	import flash.net.FileReference;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.utils.ByteArray;
	import flash.utils.getTimer;


	/**
	 * @author Saqoosha
	 */
	[SWF(backgroundColor="#FFFFFF", frameRate="30", width="1024", height="768")]
	public class exp01 extends Sprite {
		
		
		private static const PATH_PREFIX:String = 'dictation-kit-v4.1/';
		
		private static const FILE_LIST:Array = [
			'fast.jconf', 1,
			'light.jconf', 1,
			'model/lang_m/web.60k.htkdic', 30,
			'model/lang_m/web.60k.8-8.bingramv5.gz', 241,
			'model/phone_m/hmmdefs_ptm_gid.binhmm', 30,
			'model/phone_m/hmmdefs_monof_mix16_gid.binhmm', 5,
			'model/phone_m/logicalTri', 2
		];
			
			 
		private var _loader:BulkLoader;
		private var _time:int;
		private var _bridge:*;
		private var _handle:int;
		
		private var _progress:ProgressBar;
		private var _buttons:VBox;
		private var _log:TextField;


		public function exp01() {
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			_progress = new ProgressBar(this, 10, 10);
			
			_loader = new BulkLoader();
			var i:int, n:int, file:String;
			for (i = 0, n = FILE_LIST.length; i < n; i += 2) {
				file = FILE_LIST[i];
				_loader.add(PATH_PREFIX + file, {id: file, type: BulkLoader.TYPE_BINARY, weight: FILE_LIST[i + 1]});
			}
			for (i = 1; i <= 10; i++) {
				file = 'test' + i;
				_loader.add(PATH_PREFIX + file + '.wav', {id: file, type: BulkLoader.TYPE_BINARY, weight: [1, 1, 7, 2, 2, 3, 5, 5, 2, 7][i - 1]});
			}
			_loader.addEventListener(BulkProgressEvent.PROGRESS, _onLoadProgress);
			_loader.addEventListener(BulkProgressEvent.COMPLETE, _onLoaded);
			_loader.start();
		}


		private function _onLoadProgress(e:BulkProgressEvent):void {
			_progress.value = e.weightPercent;
		}


		private function _onLoaded(e:BulkProgressEvent):void {
			removeChild(_progress);
			
			var clib:CLibInit = new CLibInit();
			clib.setSprite(this);
			for each (var file:String in FILE_LIST) {
				clib.supplyFile(file, _loader.getBinary(file));
			}
			_bridge = clib.init();
			_log = TextField(getChildAt(0));
			var fmt:TextFormat = new TextFormat('_typewriter', 12);
			_log.defaultTextFormat = fmt;
			_log.setTextFormat(fmt);
			_log.wordWrap = true;
			_log.background = true;
			_log.backgroundColor = 0xf4f4f4;
			
			_buttons = new VBox(null, 10, 10);
			_buttons.enabled = false;
			for (var i:int = 1; i <= 10; i++) {
				file = 'test' + i;
				var hbox:HBox = new HBox(_buttons);
				new PushButton(hbox, 0, 0, 'PLAY ' + file.toUpperCase(), _play(file));
				new PushButton(hbox, 0, 0, 'RECOGNIZE ' + file.toUpperCase(), _recognize(file));
			}
			new PushButton(_buttons, 0, 0, 'LOAD WAV FILE', _onClickLoad);
			addChild(_buttons);
			stage.addEventListener(Event.RESIZE, _onResize);
			_onResize(null);

			_time = getTimer();
			_bridge.init(_onInit, 'light.jconf');
		}


		private function _onResize(e:Event):void {
			_log.x = 230;
			_log.y = 10;
			_log.width = stage.stageWidth - 240;
			_log.height = stage.stageHeight - 20;
		}
		
		
		private function _play(file:String):Function {
			return function(e:Event):void {
				_buttons.enabled = false;
				var wav:WAVLoader = new WAVLoader();
				wav.loadBytes(_loader.getBinary(file));
				var player:SoundDataPlayer = new SoundDataPlayer(wav);
				player.play().addEventListener(Event.SOUND_COMPLETE, function(e:*):void {
					_buttons.enabled = true;
				});
			};
		}
		
		
		private function _recognize(file:String):Function {
			return function(e:Event):void {
				_buttons.enabled = false;
				var wav:WAVLoader = new WAVLoader();
				wav.loadBytes(_loader.getBinary(file));
				var raw:ByteArray = wav.samples;
				_time = getTimer();
				_bridge.recognize(_onRecognized, _handle, raw, raw.length);
			};
		}
		
		
		private function _onInit(result:int):void {
			_trace(ObjectDumper.dumpToText(result));
			if (result) {
				_handle = result;
				_buttons.enabled = true;
				_trace('_onInit: ' + ((getTimer() - _time) / 1000) + ' msecs');
			}
		}
		
		
		private function _onClickLoad(e:Event):void {
			var file:FileReference = new FileReference();
			file.browse([new FileFilter('16khz 16bit mono WAV only.', '*.wav')]);
			file.addEventListener(Event.SELECT, function(e:Event):void {
				_buttons.enabled = false;
				file.load();
				file.addEventListener(Event.COMPLETE, function(e:Event):void {
					var wav:WAVLoader = new WAVLoader();
					wav.loadBytes(file.data);
					if (wav.numChannels == 1 && wav.bitsPerSample == 16 && wav.samplingRate == 16000) {
						var raw:ByteArray = wav.samples;
						_time = getTimer();
						_bridge.recognize(_onRecognized, _handle, raw, raw.length);
					} else {
						_trace('Invalid WAV format. 16khz 16bit mono WAV only.');
						_buttons.enabled = true;
					}
				});
			});
		}
		
		
		private function _onRecognized(result:ByteArray):void {
			if (result) {
				_trace('_onRecognized: ' + (result.readMultiByte(result.length, 'EUC-JP')));
			}
			_trace('_onRecognized: ' + ((getTimer() - _time) / 1000) + ' msecs');
			_buttons.enabled = true;
		}
		
		
		private function _trace(...args):void {
			_log.appendText(args.join(' ') + '\n');
			_log.scrollV = _log.maxScrollV + 1;
		}
	}
}


import sh.saqoo.logging.dump;

import flash.events.SampleDataEvent;
import flash.media.Sound;
import flash.utils.ByteArray;
import flash.utils.Endian;


class WAVLoader {


	private var _format:int;
	public function get format():int { return _format; }
	private var _numChannels:int;
	public function get numChannels():int { return _numChannels; }
	private var _samplingRate:int;
	public function get samplingRate():int { return _samplingRate; }
	private var _dataRate:int;
	public function get dataRate():int { return _dataRate; }
	private var _blockSize:int;
	public function get blockSize():int { return _blockSize; }
	private var _bitsPerSample:int;
	public function get bitsPerSample():int { return _bitsPerSample; }
	private var _samples:ByteArray;
	public function get samples():ByteArray { return _samples; }
	
	
	public function WAVLoader() {
	}
	
	
	public function loadBytes(bytes:ByteArray):void {
		_parse(bytes);
	}
	
	
	private function _parse(bytes:ByteArray):void {
		bytes.endian = Endian.LITTLE_ENDIAN;
		bytes.position = 0;
		var id:String = bytes.readUTFBytes(4);
		if (id != 'RIFF') throw new Error('Invalid WAV file format: id: ' + id);
		var len:uint = bytes.readUnsignedInt();
		if (len + 8 != bytes.length) throw new Error('Invalid WAV file format: length: ' + len);
		id = bytes.readUTFBytes(4);
		if (id != 'WAVE') throw new Error('Invalid WAV file format: id: ' + id);
		while (bytes.bytesAvailable) {
			id = bytes.readUTFBytes(4);
			switch (id) {
				case 'fmt ': _parseFMT(bytes); break;
				case 'data': _parseData(bytes); break;
			}
		}
	}


	private function _parseFMT(bytes:ByteArray):void {
		var len:uint = bytes.readUnsignedInt();
		_format = bytes.readShort();
		_numChannels = bytes.readShort();
		_samplingRate = bytes.readInt();
		_dataRate = bytes.readInt();
		_blockSize = bytes.readShort();
		_bitsPerSample = bytes.readShort();
		dump({
			len: len,
			formatId: _format,
			numChannels: _numChannels,
			samplingRate: _samplingRate,
			dataRate: _dataRate,
			blockSize: _blockSize,
			bitsPerSample: _bitsPerSample
		});
	}
	
	
	private function _parseData(bytes:ByteArray):void {
		var len:int = bytes.readUnsignedInt();
		trace('len: ' + (len));
		_samples = new ByteArray();
		_samples.endian = Endian.LITTLE_ENDIAN;
		bytes.readBytes(_samples, bytes.position, len);
	}
}



class SoundDataPlayer extends Sound {


	private var _wav:WAVLoader;


	public function SoundDataPlayer(wav:WAVLoader) {
		_wav = wav;
		addEventListener(SampleDataEvent.SAMPLE_DATA, _onSampleData);
	}


	private function _onSampleData(event:SampleDataEvent):void {
		var i:int,
			val:Number;
		for (i = 0; i < 2048; i++) {
			_wav.samples.position = int((event.position + i) / 44100 * _wav.samplingRate) * _wav.blockSize;
			if (_wav.samples.position >= _wav.samples.length) break;
			val = _wav.samples.readShort() / 0x8000;
			event.data.writeFloat(val);
			event.data.writeFloat(val);
		}
	}
}
