#include <sent/stddefs.h>
#include <sent/speech.h>
#include <sent/adin.h>

static SP16 *samples;
static int maxlen; ///< Number of samples, described in the header of WAVE file
static int nowlen; ///< Current number of read samples

static unsigned int sfreq; ///< Sampling frequency in Hz, specified by adin_standby()


/** 
 * Initialization: if listfile is specified, open it here.
 * 
 * @param freq [in] required sampling frequency.
 * @param arg [in] file name of listfile, or NULL if not use
 * 
 * @return TRUE on success, FALSE on failure.
 */
boolean adin_rawbytes_standby(int freq, void *arg) {
	sfreq = freq;
	return (TRUE);
}

/** 
 * @brief  Begin reading audio data from a file.
 *
 * If listfile was specified in adin_rawbytes_standby(), the next filename
 * will be read from the listfile.  Otherwise, the
 * filename will be obtained from stdin.  Then the file will be opened here.
 * 
 * @param filename [in] file name to open or NULL for prompt
 * 
 * @return TRUE on success, FALSE on failure.
 */
boolean adin_rawbytes_begin(char *data) {
	samples = (SP16 *)(data + sizeof(int));
	nowlen = 0;
	maxlen = *(int *)data / sizeof(SP16);
	return TRUE;
}

/** 
 * Try to read @a sampnum samples and returns actual sample num recorded.
 * 
 * @param buf [out] samples obtained in this function
 * @param sampnum [in] wanted number of samples to be read
 * 
 * @return actural number of read samples, -1 if EOF, -2 if error.
 */
int adin_rawbytes_read(SP16 *buf, int sampnum) {
	if (nowlen >= maxlen) return -1;
	int count = sampnum;
	if (nowlen + count > maxlen) {
		count = maxlen - nowlen;
	}
	memcpy(buf, (void *)samples + sizeof(SP16) * nowlen, sizeof(SP16) * count);
	nowlen += count;
	return count;
}

/** 
 * 
 * A tiny function to get current input raw speech file name.
 * 
 * @return string of current input speech file.
 * 
 */
char *adin_rawbytes_input_name() {
	return ("rawbytes");
}
