/*
 * julius.c
 *
 *  Created on: Sep 29, 2011
 *      Author: Saqoosha
 */

#include <stdlib.h>
#include <stdio.h>
#include "AS3.h"

#include <julius/juliuslib.h>


typedef struct {
	Jconf *jconf;
	Recog *recog;
	AS3_Val callback;
} JBHandle ;


static char buf[2048];
static char *ptr;


static AS3_Val createByteArray(void *data, int length) {
    AS3_Val baNS = AS3_String("flash.utils");
    AS3_Val baClass = AS3_NSGetS(baNS, "ByteArray");
    AS3_Val emptyParams = AS3_Array("");
    AS3_Val ba = AS3_New(baClass, emptyParams);
    AS3_ByteArray_writeBytes(ba, data, length);
    AS3_SetS(ba, "position", AS3_Int(0));
    return ba;
}


static void result_callback(Recog *recog, void *dummy) {
	WORD_INFO *winfo;
	WORD_ID *seq;
	int seqnum;
	int n, i;
	Sentence *s;
	RecogProcess *r;
	size_t len;
	JBHandle *handle = dummy;

	for (r = recog->process_list; r; r = r->next) {
		if (!r->live) continue;
		if (r->result.status < 0) continue;
		winfo = r->lm->winfo;
		for (n = 0; n < r->result.sentnum; n++) {
			s = &(r->result.sent[n]);
			seq = s->word;
			seqnum = s->word_num;
			for (i = 0; i < seqnum; i++) {
				len = strlen(winfo->woutput[seq[i]]);
				if (len) {
					strcpy(ptr, winfo->woutput[seq[i]]);
					ptr += len;
				}
			}
		}
	}
}


static int pollcount = 0;

static void poll_callback(Recog *recog, void *dummy) {
	if (++pollcount == 10) {
		flyield();
		pollcount = 0;
	}
}


static void pass1_callback(Recog *recog, void *dummy) {
	flyield();
}


static AS3_Val init(void *self, AS3_Val args) {
	jlog_set_output(stderr);

	char *file = NULL;
	AS3_ArrayValue(args, "StrType", &file);
	if (file != NULL) {
		JBHandle *handle = malloc(sizeof(JBHandle));
		memset(handle, 0, sizeof(JBHandle));
		handle->jconf = j_config_load_file_new(file);
		if (handle->jconf) {
			handle->jconf->input.speech_input = SP_RAWBYTES;
			handle->recog = j_create_instance_from_jconf(handle->jconf);
			if (handle->recog) {
				j_recog_info(handle->recog);
				callback_add(handle->recog, CALLBACK_RESULT, result_callback, handle);
				callback_add(handle->recog, CALLBACK_POLL, poll_callback, "CALLBACK_POLL");
				callback_add(handle->recog, CALLBACK_RESULT_PASS1_INTERIM, pass1_callback, "CALLBACK_RESULT_PASS1_INTERIM");
				return AS3_Ptr(handle);
			} else {
				jlog("***ERROR***: j_create_instance_from_jconf");
			}
			j_jconf_free(handle->jconf);
		}
		free(handle);
	}
	return AS3_Ptr(NULL);
}


static AS3_Val recognize(void *self, AS3_Val args) {
	JBHandle *handle = NULL;
	AS3_Val byteArray = NULL;
	int length = 0;
	AS3_Val callback = NULL;
	AS3_ArrayValue(args, "PtrType, AS3ValType, IntType, AS3ValType", &handle, &byteArray, &length, &callback);
	if (handle && byteArray && length) {
		handle->callback = callback;
		j_adin_init(handle->recog);
		int ret;
		void *data = malloc(length + sizeof(int));
		AS3_ByteArray_readBytes(data + sizeof(int), byteArray, length);
		*(int *)data = length;
		if ((ret = j_open_stream(handle->recog, data)) == 0) {
			ptr = buf;
			ret = j_recognize_stream(handle->recog);
			jlog("***INFO***: j_recognize_stream: %d, %d\n", ret, ptr - buf);
			AS3_Val result;
			if (ptr > buf) {
				result = createByteArray(buf, ptr - buf);
			} else {
				result = AS3_Null();
			}
			j_close_stream(handle->recog);
			return result;
		} else {
			jlog("***ERROR***: j_open_stream: %d\n", ret);
		}
		free(data);
	}
	return AS3_Null();
}


static AS3_Val destroy(void *self, AS3_Val args) {
	JBHandle *handle = NULL;
	AS3_ArrayValue(args, "PtrType", &handle);
	if (handle) {
		if (handle->jconf) j_jconf_free(handle->jconf);
		if (handle->recog) j_recog_free(handle->recog);
		free(handle);
	}
	return AS3_Undefined();
}


int main() {
	AS3_Val initFunc = AS3_FunctionAsync(NULL, init);
	AS3_Val recognizeFunc = AS3_FunctionAsync(NULL, recognize);
	AS3_Val destroyFunc = AS3_Function(NULL, destroy);

	AS3_Val libData = AS3_Object(
		"init: AS3ValType,"
		"recognize: AS3ValType,"
		"destroy: AS3ValType",
		initFunc,
		recognizeFunc,
		destroyFunc
	);

	AS3_Release(initFunc);
	AS3_Release(recognizeFunc);
	AS3_Release(destroyFunc);

	AS3_LibInit(libData);

	return 0;
}
