package {

	import net.hires.debug.Stats;

	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;


	/**
	 * @author hiko
	 */
	[SWF(backgroundColor="#FFFFFF", frameRate="30", width="1280", height="720")]
	public class exp02 extends Sprite {


		[Embed(source='../assets/01_walk_03.xml', mimeType='application/octet-stream')]
		private static const AtlasXML:Class;
		
		[Embed(source='../assets/01_walk_03.png')]
		private static const AtlasTexture:Class;
		
		
		private var _canvas:BitmapData;
		private var _infos:Vector.<AtlasInfo> = new Vector.<AtlasInfo>();
		private var _mcs:Vector.<MovieClip> = new Vector.<MovieClip>();
		private var _texture:BitmapData = new AtlasTexture().bitmapData;


		public function exp02() {
			_canvas = new BitmapData(1280, 720, false, 0xffffff);
			addChild(new Bitmap(_canvas));
			
			for each (var info:XML in XML(new AtlasXML())..SubTexture) {
				_infos.push(new AtlasInfo(info));
			}
			
			for (var i:int = 0; i < 1000; i++) {
				var mc:MovieClip = new MovieClip();
				mc.x = Math.random() * 1280;
				mc.y = Math.random() * 720;
				mc.currentFrame = Math.random() * 30;
				_mcs.push(mc);
			}

			addEventListener(Event.ENTER_FRAME, _draw);
			
			addChild(new Stats());
		}
		
		
		private function _draw(e:Event):void {
			var mc:MovieClip, info:AtlasInfo;
			_canvas.lock();
			_canvas.fillRect(_canvas.rect, 0xffffffff);
			for each (mc in _mcs) {
				info = _infos[mc.currentFrame];
				_canvas.copyPixels(_texture, info, new Point(mc.x - info.frameX, mc.y - info.frameY));
				if (++mc.currentFrame == 30) mc.currentFrame = 0;
			}
			_canvas.unlock();
		}
	}
}


import flash.geom.Rectangle;


class AtlasInfo extends Rectangle {
	
	
	public var frameX:Number = 0;
	public var frameY:Number = 0;


	public function AtlasInfo(info:XML) {
		super(parseInt(info.@x), parseInt(info.@y), parseInt(info.@width), parseInt(info.@height));
		frameX = parseInt(info.@frameX) + 40;
		frameY = parseInt(info.@frameY) + 70;
	}
}


class MovieClip {
	
	
	public var x:int = 0;
	public var y:int = 0;
	
	public var currentFrame:int = 0;
	
	
	public function MovieClip() {
	}
}
