﻿/**
 * GAINER flash libray
 * @author PDP Project
 * @version 1.0
 */
 
package cc.gainer {
	
import cc.gainer.*;
import flash.events.Event;
import flash.events.DataEvent;

public class Gainer extends CommandQueue{

	public var buttonPressed:Boolean;
	
	public var digitalInput:Array;
	
	public var analogInput:Array;
	
	public var currentMode:Number;
	
	public static var MODE1:Number = 1;
	
	public static var MODE2:Number = 2;
	
	public static var MODE3:Number = 3;
	
	public static var MODE4:Number = 4;
	
	public static var MODE5:Number = 5;
	
	public static var MODE6:Number = 6;
	
	public static var MODE7:Number = 7;
	
	public var timeout:Number = 1000;
	
	private var serial_net:SerialPort;
	
	private var digital:Digital;
	
	private var analog:Analog;
	
	private var verbose:Boolean = true;
	
	private var mode:Number = 1;
	
	private var sReturn:String;
	
 	public function onReady():void {
 		this.dispatchEvent(new Event('onReady'));
 	}
	
	public function onReceived(msg:String):void {}
	
	public function onPressed():void {}
	
	public function onReleased():void {}
	
	public function Gainer(ip:String='localhost', port:Number=2000, mode:Number=1, verbose:Boolean=false) {
		super();
		
		digital = new Digital(this);
		analog = new Analog(this);
		this.verbose = verbose;
		this.mode = mode;
		
		serial_net = new SerialPort(ip, port);
		serial_net.addEventListener(Event.CONNECT, this.initialize);
		serial_net.addEventListener(DataEvent.DATA, this.serialEvent);
/* 		serial_net.onReceiveStr = Proxy.create(this, serialEvent);
		serial_net.onConnected = Proxy.create(this, initialize); */
	}
	
	private function initialize(e:Event):void {
		reboot();
		setVerbose(verbose);
		configuration(mode);
		enqueue(Proxy.create(this, onReady));
	}
	
	private function setVerbose(verbose:Boolean):void {
		this.verbose = verbose;
		var c:String;
		
		if (verbose) {
			enqueue(new GainerCommand(this, "V1*"));
		} else {
			enqueue(new GainerCommand(this, "V0*"));
		}
		enqueue(new Sleep(100));
	}
	
	public function getVerbose():Boolean {
		return verbose;
	}
	
	public function reboot():void {
		trace("reboot now...");
		enqueue(new GainerCommand(this, "Q*"));
		enqueue(new Sleep(1000));
		var checkReboot:Function = function():void {
			if(sReturn == null || typeof(sReturn) == undefined || sReturn.indexOf("Q*") == -1){
				trace("reboot error !!!");
			}else{
				trace("GAINER ready to Roll. ");
			}
		};
		enqueue(Proxy.create(this, checkReboot));
	}
	
	private function configuration(mode:Number):void {
		//     ain :din :aout:dout
		//     ----:----:----:----
		// C0:    0:   0:   0:   0
		// C1:    4:   4:   4:   4
		// C2:    8:   0:   4:   4
		// C3:    4:   4:   8:   0
		// C4:    8:   0:   8:   0		←追加
		// C5:    0:  16:   0:   0	←以降一個ずつ後ろに
		// C6:    0:   0:   0:  16
		analogInput = null;
		digitalInput = null;
		switch (mode) {
		case MODE1 :
			analogInput = new Array(4);
			digitalInput = new Array(4);
			digital.configuration(4, 4);
			analog.configuration(4, 4);
			enqueue(new SynchronizedGC(this, "KONFIGURATION_1*", "KONFIGURATION_1"));
			break;
		case MODE2 :
			analogInput = new Array(8);
			digitalInput = new Array(0);
			digital.configuration(0, 4);
			analog.configuration(8, 4);
			enqueue(new SynchronizedGC(this, "KONFIGURATION_2*", "KONFIGURATION_2"));
			break;
		case MODE3 :
			analogInput = new Array(4);
			digitalInput = new Array(4);
			digital.configuration(4, 0);
			analog.configuration(4, 8);
			enqueue(new SynchronizedGC(this, "KONFIGURATION_3*", "KONFIGURATION_3"));
			break;
		case MODE4 :
			analogInput = new Array(8);
			digitalInput = new Array(0);
			digital.configuration(0, 0);
			analog.configuration(8, 8);
			enqueue(new SynchronizedGC(this, "KONFIGURATION_4*", "KONFIGURATION_4"));
			break;
		case MODE5 :
			analogInput = new Array(0);
			digitalInput = new Array(16);
			digital.configuration(16, 0);
			analog.configuration(0, 0);
			enqueue(new SynchronizedGC(this, "KONFIGURATION_5*", "KONFIGURATION_5"));
			break;
		case MODE6 :
			analogInput = new Array(0);
			digitalInput = new Array(0);
			digital.configuration(0, 16);
			analog.configuration(0, 0);
			enqueue(new SynchronizedGC(this, "KONFIGURATION_6*", "KONFIGURATION_6"));
			break;
		case MODE7:
			analogInput = new Array(0);
			digitalInput = new Array(0);
			digital.configuration(0,0);
			analog.configuration(0,0);
			enqueue(new SynchronizedGC(this, "KONFIGURATION_7*", "KONFIGURATION_7"));
			break;
		}
		currentMode = mode;
		enqueue(new Sleep(1000));
	}
	
	public function serialEvent(e:DataEvent):void {
		sReturn = e.data;
		
//		trace('Gainer.serialEvent: ' + sReturn);
//		onReceived(e.data);
		
		var i:int;
		
		if(sReturn.charAt(0) == "i" || sReturn.charAt(0) == "I"){
			var value:String;
            for (i=0;i<analogInput.length;i++){
            	value = sReturn.substring(2*i+1,2*(i+1)+1);
            	analogInput[i] = parseInt(value,16);
            }
		} else if(sReturn.charAt(0) == "r" || sReturn.charAt(0) == "R"){
			var v:Number = parseInt(sReturn.substring(1,5),16);
            for(i=0;i<digitalInput.length;i++){
            	var c:Number = 1&(v>>i);
            	if(c==1){
            		digitalInput[i] = true;
            	}else{
            		digitalInput[i] = false;
            	}
            }
		} else if(sReturn.charAt(0) == "N"){
              buttonPressed = true;
//			  onPressed();
			this.dispatchEvent(new Event('onPress'));
			  //dispatchEvent({type:"onPressed"});
        } else if(sReturn.charAt(0) == "F"){
              buttonPressed = false;
//			  onReleased();
			this.dispatchEvent(new Event('onRelease'));
			  //dispatchEvent({type:"onReleased"});
        }
		
		var ev:DataEvent= new DataEvent('onReceived');
		ev.data = sReturn;
		dispatchEvent(ev);
		//dispatchEvent({type:"onReceived", sReturn:sReturn});
	}
	
	public function turnOnLED():void {
		enqueue(new SynchronizedGC(this, "h*", "h"));
	}
	public function turnOffLED():void {
		enqueue(new SynchronizedGC(this, "l*", "l"));
	}
	
	public function peekDigitalInput():void {
		digital.peek();
	}
	public function beginDigitalInput():void {
		digital.begin();
	}
	public function endDigitalInput():void {
		digital.end();
	}
	public function digitalOutput(obj:*):void {
		digital.out(obj);
	}
	public function setHigh(obj:*):void {
		digital.high(obj);
	}
	public function setLow(obj:*):void {
		digital.low(obj);
	}
	public function peekAnalogInput():void {
		analog.peek();
	}
	public function beginAnalogInput():void {
		analog.begin();
	}
	public function endAnalogInput():void {
		analog.end();
	}
	public function analogOutput(ch:*, value:*=undefined):void {
		analog.out(ch,value);
	}
	public function write(what:String):void {
		serial_net.writeString(what);
	}
	//mode7のみ
	//line毎に処理
	public function scanLine(line:Number,values:Array):void {
		if(currentMode==Gainer.MODE7){
			var s:String = "a";
			var sv:String = "";
			if(values.length == 8){
				if(line<8){
					s += line.toString(16).toUpperCase();
				}else{
					trace("Gainer error!! out of bounds");
				}
				for(var i:int=0;i<8;i++){
					if(values[i]<0)values[i] = 0;
					else if(values[i]>15)values[i]=15;
					s += values[i].toString(16).toUpperCase();
				}
				s += "*";
				enqueue(new SynchronizedGC(this, s, "a"));
			}else{
				trace("Gainer error!! number of values");
			}
		}else{
			trace("Gainer error!! this method can use only MODE7");
		}
	}
	//mode7のみ
	//LEDmatrix全体を処理
	public function scanMatrix(values:Array):void {
		if(currentMode==Gainer.MODE7){
			if(values.length == 64){
				for(var col:int=0;col<8;col++){
					var v:Array = new Array(8);
					for(var i:int=0;i<8;i++){
						v[i] = values[col*8+i];
					}
					scanLine(col,v);
				}
			}
		}else{
			trace("Gainer error!! this method can use only MODE7");
		}
	}
	public function ampGainAGND(gain:Number):void {
		var s:String ="G";
	 	if(gain>=0 && gain<16){
	  		s += gain.toString(16).toUpperCase();
  			s += "1";
	 	}else{
	 		trace("Gainer error!! gain");
	 	}
	 	s +="*";
	 	enqueue(new SynchronizedGC(this, s, "G"));
	}
	public function ampGainDGND(gain:Number):void {
		var s:String ="G";
	  	if(gain>=0 && gain<16){
	   		s += gain.toString(16).toUpperCase();
	   		s += "0";
	  	}else{
	  		trace("Gainer error!! gain");
	 	}
	  	s +="*";
	   	enqueue(new SynchronizedGC(this, s, "G"));
	}
	public function startLog():void {
		write("startLog");
	}
	public function stopLog():void {
		write("stopLog");
	}
	public function clearLog():void {
		write("clearLog");
	}
	public function sleep(wait:Number):void {
		enqueue(new Sleep(wait));
	}
	public static function remap(input:Number, inmin:Number, inmax:Number, outmin:Number, outmax:Number):Number {
		var output:Number = ((input-inmin)*(outmax-outmin))/((inmax-inmin))+outmin;
		if(output < outmin) output = outmin;
		else if(output > outmax) output = outmax;
		return output;
	}
}


}