﻿/**
 * GAINER flash libray
 * @author PDP Project
 * @version 1.0
 */

package cc.gainer {
	
import flash.events.DataEvent;
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.IOErrorEvent;
import flash.events.SecurityErrorEvent;
import flash.net.XMLSocket;
import flash.events.ProgressEvent;

public class SerialPort extends EventDispatcher {
	
	private var ip:String;
	private var port:Number;
	private var socket:XMLSocket;
	
	public function SerialPort(ip:String, port:Number) {
		super(this);
		
		socket = new XMLSocket();
		this.ip = ip;
		this.port = port;
		
/* 		var scope = this;
		socket.onXML = function(src:XML) {
			scope.onReceiveStr(src.toString());
		};
		
		socket.onConnect = function(success:Boolean) {
			if (success) {
				trace("connected to the server");
				scope.onConnected();
			} else {
				trace("connection failed");
			}
		}; */
		socket.addEventListener(Event.CONNECT, this._handleOnConnect);
		socket.addEventListener(Event.CLOSE, this._handleError);
		socket.addEventListener(DataEvent.DATA, this._handleOnData);
		socket.addEventListener(IOErrorEvent.IO_ERROR, this._handleError);
		socket.addEventListener(SecurityErrorEvent.SECURITY_ERROR, this._handleError);
		socket.addEventListener(ProgressEvent.PROGRESS, this._handleError);
		socket.connect(ip, port);
		
//		trace('connecting:', ip, port);
	}
	
	private function _handleError(e:Event):void {
		trace(e);
	}
	
	private function _handleOnConnect(e:Event):void {
//		trace(e);
		dispatchEvent(e);
//		this.onConnected();
	}
	
	private function _handleOnData(e:DataEvent):void {
//		trace(e);
		dispatchEvent(e);
//		this.onReceiveStr(String(e.data));
	}
	
/* 	public function onReceiveStr(str:String):void {
	}
	
	public function onConnected():void {
	} */
	
	public function close():void {
		socket.close();
	}
	
	public function writeString(param:String):void {
//		trace('SerialPort.writeString: ' + param);
		socket.send(param);
	}
	
}

}