#import "IRSensorView.h"

@implementation IRSensorView

- (id)initWithFrame:(NSRect)frameRect
{
	if ((self = [super initWithFrame:frameRect]) != nil) {
		irData = nil;
		color[0] = [NSColor redColor];
		color[1] = [NSColor greenColor];
	}
	return self;
}

- (void)drawRect:(NSRect)rect
{
	[[NSColor whiteColor] set];
	NSRectFill(rect);

	if (irData != nil) {
		int i;
		for (i = 0; i < 2; i++) {
			if (irData[i].x < 0x3ff) {
				[color[i] set];
				NSRect r = NSMakeRect((float)irData[i].x / 0x3ff * rect.size.width - 5,
					(float)irData[i].y / 0x2ff * rect.size.height - 5, 10, 10);
				//NSLog(@"%d, %@", i, NSStringFromRect(r));
				NSBezierPath *b = [NSBezierPath bezierPath];
				[b appendBezierPathWithOvalInRect:r];
				[b fill];
			}
		}
	}
}

- (void) drawSensor: (IRData[4])data
{
	irData = data;
	[self setNeedsDisplay:YES];
}

@end
