//
//  WiiFlashPacket.h
//  WiimoteServer
//
//  Created by hiko on 07/05/04.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <WiiRemote/WiiRemote.h>
#import <WiiRemote/WiiRemoteDiscovery.h>
#import "AsyncSocket.h"

@interface WiiFlashPacket : NSObject {
	bool			buttonState[16];
	float			accX, accY, accZ;

	unsigned char	hasNunchuk;
	bool			nunchukButtonState[2];
	float			stickX, stickY;
	float			nunchukAccX, nunchukAccY, nunchukAccZ;

	bool			ir1found, ir2found;
	float			irX1, irX2, irY1, irY2;
	
	WiiAccCalibData	calib;
}

- (void) setButtonState:(WiiButtonType)button isPressed:(BOOL)isPressed;
- (void) setAcceleration:(WiiAccelerationSensorType)type accX:(unsigned char)accX accY:(unsigned char)accY accZ:(unsigned char)accZ;
- (void) setCalibData:(WiiAccCalibData)data forType:(WiiAccelerationSensorType)type;
- (void) setIRRawData:(IRData[4])irData;

- (NSData *) currentStateAsData;

- (void) dump;

@end
