package {
	
	import net.saqoosha.sound.oscillator.Oscillator;
	import net.saqoosha.sound.oscillator.SineOscillator;
	
	import nu.mine.flashnet.sound.core.AudioDataProvider;
	import nu.mine.flashnet.sound.core.PCMSoundFormat;
	import net.saqoosha.sound.oscillator.SquareOscillator;

	public class SoundDataProvider extends AudioDataProvider {

		private var _oscillator:Oscillator;
		private var _amp:Oscillator;
		
		public function SoundDataProvider() {
			var fmt:PCMSoundFormat = new PCMSoundFormat(44100, 16, 1);
			super(fmt);
			this._oscillator = new SquareOscillator(400, 1.0); //new SineOscillator(400, 1.0);
			this._amp = new SineOscillator(2.2, 20.0);
		}
		
		protected override function fillBuffer(numSamples:int):void {
			for(var i:int = 0; i < numSamples; ++i) {
				this._oscillator.frequency = this._amp.getNextSample() + 440;
				this.buffer.writeMonoSample(this._oscillator.getNextSample());
			}
		}
		
		public function setPitch(freq:Number):void {
			
		}
		
	}

}
