package net.saqoosha.sound.oscillator {
	
	public class Oscillator {
		
		public static const TWO_PI:Number = Math.PI * 2;

		protected var _phase:Number;
		protected var _freq:Number;
		protected var _amp:Number;
		private var _sampleRate:Number;

		public function Oscillator(freq:Number = 440, amp:Number = 1.0, rate:Number = 44100) {
			this._phase = 0;
			this._freq = freq;
			this._amp = amp;
			this._sampleRate = rate;
		}
		
		protected function getNextSampleValue():Number {
			throw(new Error('Must override by sub class.'));
		}
		
		public function getNextSample():Number {
			return this.getNextSampleValue() * this._amp;
		}
		
		protected function nextPhase():void {
			this._phase += this._freq * (TWO_PI / this._sampleRate);
			if (this._phase > TWO_PI) {
				this._phase -= TWO_PI;
			}
		}
		
		public function set frequency(f:Number):void {
			this._freq = f;
		}
		
	}
		
}
