package nu.mine.flashnet.sound.core
{
	import flash.utils.ByteArray;
	/**
	 * A base class for users to override. Subclasses must call super(fmt) to set the format of the data that will be provided.
	 * @author spender
	 * 
	 */
	public class AudioDataProvider implements IAudioDataProvider //consider this class abstract
	{
		protected var soundFormat:PCMSoundFormat

		/**
		* The NumberToIntegerAudioBuffer into which users must write audio data
		*/
		protected var buffer:NumberToIntegerAudioBuffer;
		/**
		 * Creates an AudioDataProvider of format fmt.
		 * @param fmt The format of Audio data that subclasses will provide.
		 * @return 
		 * 
		 */
		public function AudioDataProvider(fmt:PCMSoundFormat)
		{
			buffer=new NumberToIntegerAudioBuffer(fmt);
			soundFormat=fmt;
		}
		/**
		 * Called by the "framework" when more data is required. Subclasses must override this method, and call buffer.writeMonoSample for every monophonic sample that is provided by the user. This means that for stereo sounds, buffer.writeMonoSample must be called 2*numSamples times.
		 * @param numSamples the number of samples the framework expects to find in the buffer.
		 * 
		 */
		protected function fillBuffer(numSamples:int):void
		{
			throw(new Error("fillbuffer is unimplemented. AudioDataProvider must be subclassed and fillBuffer overridden"));
		}
		/**
		 * Called by the framework when more data is required for playback
		 * @param numSamples the number of samples expected in the returned ByteArray
		 * @return A ByteArray containing the audio data
		 * 
		 */
		public function getData(numSamples:int):ByteArray
		{
			fillBuffer(numSamples);
			var audioByteArray:ByteArray=buffer.flush();
			if(audioByteArray.length/(soundFormat.channels*soundFormat.sampleSize)!=numSamples)
			{
				throw(new Error("fillBuffer returned incorrect number of bytes"));
			}
			return audioByteArray;
		}
		
		/**
		 * Returns the format of audio that this AudioDataProvider will be providing
		 * @return A PCMSoundFormat representing the format of the audio data
		 * 
		 */
		public function getFormat():PCMSoundFormat
		{
			return soundFormat;
		}
		
	}
}