package nu.mine.flashnet.sound.core
{
	import flash.utils.ByteArray;

	/**
	 * Any data provider must implement this interface. Users should consider extending AudioDataProvider instead.
	 * @author spender
	 * 
	 */
	public interface IAudioDataProvider
	{
		/**
		 * Supplies the format of data returned by a call to getData
		 * @return The format of the audio
		 * 
		 */
		function getFormat():PCMSoundFormat;
		/**
		 * Called by PlaybackEngine when more audio data is required
		 * @param numSamples The number of samples that must be written into the ByteArray
		 * @return The audio data
		 * 
		 */
		function getData(numSamples:int):ByteArray;
	}
}