package nu.mine.flashnet.sound.core
{
	import flash.utils.ByteArray;
	import flash.utils.Endian;
	
	/**
	 * A class that buffers samples (of type Number), converts them to the integer PCM audio equivalent and stores them in a ByteArray 
	 * @author spender
	 * 
	 */
	public class NumberToIntegerAudioBuffer
	{
		private var targetSoundFormat:PCMSoundFormat;
		
		//private var byteArray:ByteArray;
		private var buffer:Array;
		private var sampleCount:int;
		/**
		 * Creates a new buffer
		 * @param targetSoundFormat The aduio format into which samples will be converted internally.
		 * @return 
		 * 
		 */
		public function NumberToIntegerAudioBuffer(targetSoundFormat:PCMSoundFormat)
		{
			sampleCount=0;
			buffer=[];
			//byteArray=new ByteArray();
			//byteArray.endian=Endian.LITTLE_ENDIAN;
			this.targetSoundFormat=targetSoundFormat;
		}
		/**
		 * Takes a floating point value, converts it into the targetSoundFormat (see constructor) and stores the value.
		 * The conversion is currently quick and dirty.
		 * @param val A floating point value. Will be clipped to -1.0 to +1.0
		 * 
		 */
		public function writeMonoSample(val:Number):void
		{
			buffer.push(val);
			++sampleCount;
		}
		private function getIntegerFormatByteArray():ByteArray
		{
			var byteArray:ByteArray=new ByteArray();
			byteArray.endian=Endian.LITTLE_ENDIAN;
			for(var i:int=0;i<buffer.length;++i)
			{
				var val:Number=buffer[i];
				val=Math.max(val,-1.0);
				val=Math.min(val,1.0);
			
				switch(targetSoundFormat.sampleSizeBits)
				{
					case 8:
						byteArray.writeByte((val+1)*127.5);
						break;
					case 16:
						
						byteArray.writeShort(val*32767);
						break;
					default:
						throw(new Error("cannot convert"));
				}
			}
			return byteArray;
		}
		/**
		 * Clears the buffer. Correct number of samples must be stored in the buffer for this to succeed (i.e. length must be sample aligned)
		 * @return The contents of the buffer before it was cleared.
		 * 
		 */
		public function flush():ByteArray
		{
			if(buffer.length%targetSoundFormat.channels!=0)
			{
				throw(new Error("data length to channels mismatch"));
			}
			var ba:ByteArray=getIntegerFormatByteArray();
			buffer=[];
			sampleCount=0;
			return ba;
			
		}
	}
}