package nu.mine.flashnet.sound.core
{
	/**
	 * Describes the three vital aspects of a PCM waveform, samplerate, sampledepth, channels
	 * @author spender
	 * 
	 */
	public class PCMSoundFormat
	{
		/**
		* The audio sample rate in hZ 44100, 22050, 11025 or 5512.5
		*/
		public var sampleRate:Number;
		/**
		* The audio sample rate index according to documentation.
		*/
		public var sampleRateIndex:Number;
		/**
		* Audio bit depth, either 8 or 16
		*/
		public var sampleSizeBits:int;
		/**
		* Audio depth in bytes, either 1 or 2
		*/
		public var sampleSize:int;
		/**
		* 1=mono, 2=stereo 
		*/
		public var channels:int;
		/**
		 * Construct a PCMSoundFormat object
		 * @param sampleRate The audio sample rate in hZ 44100, 22050, 11025 or 5512.5
		 * @param sampleSizeBits Audio bit depth, either 8 or 16
		 * @param channels 1=mono, 2=stereo 
		 * 
		 */
		public function PCMSoundFormat(sampleRate:Number,sampleSizeBits:int,channels:int)
		{
			switch(sampleRate)
			{
				case 44100:
					sampleRateIndex=3;
					break;
				case 22050:
					sampleRateIndex=2;
					break;
				case 11025:
					sampleRateIndex=1;
					break;
				case 5512.5:
					sampleRateIndex=0;
					break;
				default:
					throw(new Error("bad sample rate"));
					break;
			}

			if(!(sampleSizeBits==8||sampleSizeBits==16))
			{
				throw(new Error("bad sampleSize. 8 or 16"));
			}
			if(!(channels==1||channels==2))
			{
				throw(new Error("num of channels should be 1 or 2"));
			}
			this.channels=channels;
			this.sampleSize=sampleSizeBits/8;

			this.sampleRate=sampleRate;

			this.sampleSizeBits=sampleSizeBits;
		}
	}
}