package nu.mine.flashnet.sound.core
{
	import flash.events.Event;
	import flash.media.Sound;

	/**
	 * Event which notifies listeners of a new sound object. Carries the sound object as the 'sound' parameter. Emitted asynchronously by SoundFactory instance after a call to createSoundObject or createSilentSoundObject
	 * @author spender
	 * 
	 */
	internal class SoundEvent extends Event
	{
		internal static const SOUND_OBJECT_CREATED:String="soundObjectCreated";

		/**
		* the Sound instance that was created
		*/
		internal var sound:Sound;
		/**
		 * This event should only be instantiated by SoundFactory
		 * @param type The type of the event
		 * @param sound The sound that was just created
		 * @param bubbles Same as Event
		 * @param cancelable Same as Event
		 * 
		 */
		public function SoundEvent(type:String, sound:Sound, bubbles:Boolean=false, cancelable:Boolean=false)
		{
			this.sound=sound;
			super(type, bubbles, cancelable);
		}
		
	}
}