package nu.mine.flashnet.sound.synthesis
{
	import nu.mine.flashnet.sound.core.PCMSoundFormat;
	import flash.events.EventDispatcher;
	import flash.events.Event;
	
	/**
	 * Generates amplitude values for ADSR envelopes
	 * ADSR=Attack, Decay, Sustain, Release
	 * 
	 * A WORK IN PROGRESS.
	 * 
	 * @author ChrisS
	 * 
	 */
	public class ADSREnvelope extends EventDispatcher
	{
		public var attack:Number;
		public var decay:Number;
		public var sustain:Number;
		public var release:Number;
		private var soundFormat:PCMSoundFormat;
		//private var amplitudeData:Array;
		private var currentVal:Number;
		private var releaseStep:Number;
		private var releasing:Boolean;
		private var playing:Boolean;
		private var timeInSamples:int;
		private var startAmplitude:Number;
		public function ADSREnvelope(attack:Number,decay:Number,sustain:Number,release:Number,soundFormat:PCMSoundFormat)
		{
			playing=false;
			this.soundFormat=soundFormat;
			this.attack=attack;
			this.decay=decay;
			this.sustain=sustain;
			this.release=release;
			currentVal=0;
			releasing=true;
			releaseStep=0;
			
		}
		public function triggerEnvelope():void
		{
			playing=true;
			releasing=false;
			startAmplitude=currentVal;
			timeInSamples=1; //no point in starting at zero as this gives a sample worth of zero before onset of env.
		}
		public function releaseEnvelope():void
		{
			releasing=true;
			var releaseTimeInSamples:int=(release*soundFormat.sampleRate);
			releaseStep=(currentVal/releaseTimeInSamples);
		}
		public function getNextAmplitude():Number
		{
			if(!playing)return 0;
			var val:Number;
			var offset:Number=(timeInSamples as Number)/soundFormat.sampleRate;
			
			if(!releasing)
			{
				if(offset<attack)			//attack phase
				{
					val=startAmplitude+(1-startAmplitude)*offset/attack;
				}
				else
				if(offset<(attack+decay))	//decay phase
				{
					val=1.0-((offset-attack)/decay)*(1.0-sustain);
				}
				else
				if(offset>=(attack+decay))	//sustain phase
				{
					val=sustain;
				}
			}
			else
			{
				val=currentVal-releaseStep;	//release phase
			}
			
			if(val<0)
			{
				playing=false;
				var event:Event=new Event(Event.COMPLETE);
				this.dispatchEvent(event);
			}
			currentVal=Math.max(0,val);
			++timeInSamples;
			return currentVal;

		}
	}
}