package nu.mine.flashnet.sound.synthesis
{
	/**
	 * 
	 * @author http://www.musicdsp.org/showone.php?id=26
	 * 
	 */
	public class MoogFilter
	{
		private var outputStore1:Number;
		private var outputStore2:Number;
		private var outputStore3:Number;
		private var outputStore4:Number;
		private var inputStore1:Number;
		private var inputStore2:Number;
		private var inputStore3:Number;
		private var inputStore4:Number;
		public function MoogFilter()
		{
			reset();
		}
		public function reset():void
		{
			outputStore1=outputStore2=outputStore3=outputStore4=inputStore1=inputStore2=inputStore3=inputStore4=0.0;
		}
		public function run( inputSample:Number, filterCutoff:Number,  resonance:Number):Number
		{
			var f:Number = filterCutoff * filterCutoff * 1.16;
			var fb:Number = resonance * (1.0 - 0.15 * f * f);
			inputSample -= outputStore4 * fb;
			inputSample *= 0.35013 * (f*f)*(f*f);
			outputStore1 = inputSample + 0.3 * inputStore1 + (1 - f) * outputStore1; // Pole 1
			inputStore1  = inputSample;
			outputStore2 = outputStore1 + 0.3 * inputStore2 + (1 - f) * outputStore2;  // Pole 2
			inputStore2  = outputStore1;
			outputStore3 = outputStore2 + 0.3 * inputStore3 + (1 - f) * outputStore3;  // Pole 3
			inputStore3  = outputStore2;
			outputStore4 = outputStore3 + 0.3 * inputStore4 + (1 - f) * outputStore4;  // Pole 4
			inputStore4  = outputStore3;
			return outputStore4;
		}
	}
}